package com.iplatform.security.callback;

import com.iplatform.base.util.PlatformRSAUtils;
import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * 移动端（H5），使用：用户名、密码（AES） + 普通验证码登录方式。
 * <p>因为移动端与PC端密码加密方式不一致，所以无法复用PC登录验证模式，因此重新定义！</p>
 * @author 时克英
 * @date 2023-12-28
 */
public class MobilePassCaptchaLoginCallback extends EncryptPasswordLoginCallback{

    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
        Authentication usernamePasswordAuthenticationToken = SecurityContextHolder.getContext().getAuthentication();
        String password = usernamePasswordAuthenticationToken.getCredentials().toString();
        try {
            // 移动端，只支持AES密码加密，目前情况。2023-12-28
            String originPassword = PlatformRSAUtils.getAesDecryptValue(password);
            logger.debug("......... 解密的password = {}", originPassword);
            return this.passwordEncoder.matches(originPassword, userPrincipal.getPassword());
        } catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("解析登录密码错误:" + e.getMessage(), e);
        }
    }
}
