package com.iplatform.security.callback;

import com.iplatform.base.Constants;
import com.iplatform.base.callback.GeneralLoginCallback;
import com.iplatform.model.po.S_user_core;
import com.walker.cache.CacheProvider;
import com.walker.web.UserPrincipal;

/**
 * APP方式登录回调实现。
 * @author 时克英
 * @date 2023-01-26
 * @date 2023-01-28 短信验证码登录方式回调
 */
public class SmsCodeLoginCallback extends GeneralLoginCallback {

    /**
     * 重写方法，短信验证码登录，需要首先验证。否则在移动端（特别是用户不存在，还没注册情况下）直接跳过并调用接口。
     * @return
     * @date 2023-06-30
     */
    @Override
    public boolean isValidateCaptcha() {
         /*APP登录提交不需要使用验证码，仅在接收短信时使用
         短信验证码作为密码使用，所以没有验证码了!*/
        return true;
    }

    /**
     * 暂未使用到该方法，看后续情况。
     * @param loginId
     * @return
     */
    @Deprecated
    @Override
    public Object[] queryLoginUser(String loginId) {
        Object[] userInfo = new Object[2];
        S_user_core userCore =  this.userService.queryLoginUserOnly(loginId);
        userInfo[0] = userCore;
        userInfo[1] = null;
        return userInfo;
    }

    /**
     * 验证密码实现。
     * @param userPrincipal
     * @return
     * @date 2023-06-30 重新修改，由于短信验证码仍然必须提前校验，所以现在这里就无需作为密码。
     */
    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
//        logger.warn("App登录密码验证: 可能是短信或者密码，根据业务情况实现，这里'默认验证通过'");
        /*DefaultAuthenticationToken authenticationToken = (DefaultAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        RequestLogin requestLogin = authenticationToken.getRequestLogin();
        String smsCode = this.getSmsCode(requestLogin.getUuid());
        if(StringUtils.isNotEmpty(smsCode) && requestLogin.getPassword().equals(smsCode)){
            logger.debug("app验证密码成功，smsCode={}, password={}", smsCode, requestLogin.getPassword());
            return true;
        }
        logger.error("app登录验证码错误，smsCode = " + smsCode + ", inputPass = " + requestLogin.getPassword());
        return false;*/
        return true;
    }

    private String getSmsCode(String uuid){
        String verifyKey = Constants.CAPTCHA_CODE_PREFIX + uuid;
        // 缓存中获取之前生成的短信验证码
        return this.captchaCacheProvider.getCacheData(verifyKey);
    }

    public void setCaptchaCacheProvider(CacheProvider<String> captchaCacheProvider) {
        this.captchaCacheProvider = captchaCacheProvider;
    }

    private CacheProvider<String> captchaCacheProvider;
}
