package com.iplatform.security.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

@ConfigurationProperties(prefix = "iplatform.security")
public class SecurityProperties {

    private List<String> anonymousList = null;

    private List<String> permitList = null;

    private String supervisorPassword = null;

    private boolean corsEnabled = false;

    private boolean allowPcUserAccessApp = true;

    private long tokenExpireWeb = 120;              // PC端默认2小时
    private long tokenExpireMobile = 60 * 24 * 15;  // 移动端默认15天

    // 支持手机登录时自动注册（手机不存在则，直接注册）
    private boolean allowMobileLoginReg = false;

    private boolean userNameIsPhone = false;

    /**
     * 用户体系（用户名）都是手机号。
     * @return
     * @date 2023-06-28
     */
    public boolean isUserNameIsPhone() {
        return userNameIsPhone;
    }

    public void setUserNameIsPhone(boolean userNameIsPhone) {
        this.userNameIsPhone = userNameIsPhone;
    }

    /**
     * 支持手机登录时自动注册（手机不存在则，直接注册）
     * @return
     * @date 2023-06-28
     */
    public boolean isAllowMobileLoginReg() {
        return allowMobileLoginReg;
    }

    public void setAllowMobileLoginReg(boolean allowMobileLoginReg) {
        this.allowMobileLoginReg = allowMobileLoginReg;
    }

    /**
     * 返回PC端token失效时间（分钟），默认：120
     * @return
     * @date 2023-03-28
     */
    public long getTokenExpireWeb() {
        return tokenExpireWeb;
    }

    public void setTokenExpireWeb(long tokenExpireWeb) {
        this.tokenExpireWeb = tokenExpireWeb;
    }

    /**
     * 返回移动端token失效时间（分钟），默认：60 * 24 * 15 （15天）
     * @return
     * @date 2023-03-28
     */
    public long getTokenExpireMobile() {
        return tokenExpireMobile;
    }

    public void setTokenExpireMobile(long tokenExpireMobile) {
        this.tokenExpireMobile = tokenExpireMobile;
    }

    public boolean isAllowPcUserAccessApp() {
        return allowPcUserAccessApp;
    }

    /**
     * 设置是否允许'后台PC用户'访问登录手机APP
     * @param allowPcUserAccessApp
     * @date 2023-03-20
     */
    public void setAllowPcUserAccessApp(boolean allowPcUserAccessApp) {
        this.allowPcUserAccessApp = allowPcUserAccessApp;
    }

    /**
     * 是否启用跨域配置，在 Gateway 模式下，由于网关已经配置，这里业务就不需要重复配置了。
     * @return
     * @date 2022-12-28
     */
    public boolean isCorsEnabled() {
        return corsEnabled;
    }

    public void setCorsEnabled(boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
    }

    /**
     * 获取超级管理员密码(秘文)
     * @return
     * @date 2022-12-02
     */
    public String getSupervisorPassword() {
        return supervisorPassword;
    }

    public void setSupervisorPassword(String supervisorPassword) {
        this.supervisorPassword = supervisorPassword;
    }

    /**
     * 获得配置的已认证用户都能访问的地址集合。
     * @return
     * @date 2022-11-13
     */
    public List<String> getPermitList() {
        return permitList;
    }

    public void setPermitList(List<String> permitList) {
        this.permitList = permitList;
    }

    /**
     * 获得配置的匿名访问地址集合
     * @return
     */
    public List<String> getAnonymousList() {
        return anonymousList;
    }

    public void setAnonymousList(List<String> anonymousList) {
        this.anonymousList = anonymousList;
    }

    /**
     * 用户名密码方式登录，配置的验证码提供者。
     * @return
     * @date 2023-03-14
     */
    public String getLoginCaptchaUserPass() {
        return loginCaptchaUserPass;
    }

    public void setLoginCaptchaUserPass(String loginCaptchaUserPass) {
        this.loginCaptchaUserPass = loginCaptchaUserPass;
    }

    /**
     * 手机短信登录方式，配置的验证码提供者。
     * @return
     * @date 2023-03-14
     */
    public String getLoginCaptchaSmsCode() {
        return loginCaptchaSmsCode;
    }

    public void setLoginCaptchaSmsCode(String loginCaptchaSmsCode) {
        this.loginCaptchaSmsCode = loginCaptchaSmsCode;
    }

    private String loginCaptchaUserPass = null;
    private String loginCaptchaSmsCode = null;
}
