package com.iplatform.security.event;

import com.iplatform.base.event.RoleSecurityChangeEvent;
import com.walker.web.security.ResourceLoadProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

/**
 * 角色对应权限更新监听器，在角色权限修改后，会触发该事件来响应。
 * <p>如果不通知重新加载，则角色分过权限后，用户仍然看不到（需要重新启动）</p>
 * @author shikeying
 * @date 2023-05-07 移植老代码
 */
public class RoleSecurityUpdateListener implements ApplicationListener<RoleSecurityChangeEvent> {

	private Logger logger = LoggerFactory.getLogger(getClass());

//	private MySecurityMetadataSource securityMetaSource;
//
//	public void setSecurityMetaSource(MySecurityMetadataSource securityMetaSource) {
//		assert (securityMetaSource != null);
//		this.securityMetaSource = securityMetaSource;
//	}

	private ResourceLoadProvider resourceLoaderProvider;

	public void setResourceLoaderProvider(ResourceLoadProvider securityMetaSource) {
		this.resourceLoaderProvider = securityMetaSource;
	}

	@Override
	public void onApplicationEvent(RoleSecurityChangeEvent event) {
		resourceLoaderProvider.reloadResource();
		logger.info("*************************************************");
		logger.info("*  系统重新加载了角色权限数据");
		logger.info("*************************************************");
	}

}
