package com.iplatform.security.util;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.security.callback.*;
import com.walker.web.CaptchaType;
import com.walker.web.LoginType;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 登录回调工具类。
 * @author 时克英
 * @date 2023-01-26
 */
public class LoginCallbackUtils {

    protected static final Logger logger = LoggerFactory.getLogger(LoginCallbackUtils.class);

//    public static final PlatformLoginCallback getLoginCallbackBean(UserType userType){
//        if(userType == UserType.UserEquipment){
//            throw new UnsupportedOperationException("暂不支持设备连接登录回调");
//        } else if(userType == UserType.UserApp){
//            return getLoginCallbackBean(LoginType.MOBILE);
//        } else {
//            return getLoginCallbackBean(LoginType.PC);
//        }
//    }

    /**
     * 根据登录类型，查找登录回调定义实现。
     * @param loginType 登录类型，参考：{@linkplain LoginType}
     * @param encryptPassword 如果密码方式，密码是否加密
     * @return
     */
    public static final PlatformLoginCallback getLoginCallbackBean(LoginType loginType, boolean encryptPassword, CaptchaType captchaType){
        if(loginType == LoginType.UserPassword){
            if(encryptPassword){
                return PlatformCallbackPostProcessor.getCallbackMultipleBean(EncryptPasswordLoginCallback.class);
            } else {
                logger.error("'SimplePasswordLoginCallback'还未配置，明文密码登录已不再支持！仅用于测试。");
                return PlatformCallbackPostProcessor.getCallbackMultipleBean(SimplePasswordLoginCallback.class);
            }
        } else if(loginType == LoginType.SmsCode){
            return PlatformCallbackPostProcessor.getCallbackMultipleBean(SmsCodeLoginCallback.class);
        } else if(loginType == LoginType.MobilePassword){
            if(captchaType == CaptchaType.None){
                return PlatformCallbackPostProcessor.getCallbackMultipleBean(NoneCaptchaLoginCallback.class);
            } else {
                return PlatformCallbackPostProcessor.getCallbackMultipleBean(MobilePassCaptchaLoginCallback.class);
            }
//            return PlatformCallbackPostProcessor.getCallbackMultipleBean(NoneCaptchaLoginCallback.class);
        } else if(loginType == LoginType.ThirdParty){
            return PlatformCallbackPostProcessor.getCallbackMultipleBean(ThirdPartyLoginCallback.class);
        } else if(loginType == LoginType.Wechat){
            return PlatformCallbackPostProcessor.getCallbackMultipleBean(WechatLoginCallback.class);
        } else {
            throw new UnsupportedOperationException("暂不支持登录类型:" + loginType);
        }
    }
}
