/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.security.exception.PcUserStopAppException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseCode;
import com.walker.web.ResponseValue;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String message = null;
        int code = ResponseCode.USER_CREDENTIALS_ERROR.getCode();
        if (exception instanceof AccountExpiredException) {
            message = ResponseCode.USER_ACCOUNT_EXPIRED.getMessage();
            this.logger.debug("---------> " + message);
        } else {
            message = exception instanceof BadCredentialsException ? ResponseCode.USER_CREDENTIALS_ERROR.getMessage() : (exception instanceof CredentialsExpiredException ? "\u5bc6\u7801\u8fc7\u671f,\u767b\u5f55\u5931\u8d25\uff01" : (exception instanceof DisabledException ? ResponseCode.USER_ACCOUNT_DISABLE.getMessage() : (exception instanceof LockedException ? ResponseCode.USER_ACCOUNT_LOCKED.getMessage() : (exception instanceof InternalAuthenticationServiceException ? ResponseCode.USER_CREDENTIALS_ERROR.getMessage() : (exception instanceof PcUserStopAppException ? "\u975eApp\u7528\u6237\u65e0\u6cd5\u767b\u5f55\u624b\u673a\u7aef!" : "\u767b\u5f55\u5931\u8d25\uff01")))));
        }
        try {
            ServletUtils.renderString((HttpServletResponse)response, (String)JsonUtils.objectToJsonString((Object)ResponseValue.error((String)message)));
        }
        catch (Exception e) {
            this.logger.error("\u8ba4\u8bc1\u5931\u8d25:" + request.getRequestURI(), (Throwable)e);
        }
    }
}

