/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.iplatform.security.DefaultAuthenticationToken;
import com.iplatform.security.DefaultUserDetails;
import com.iplatform.security.exception.PcUserStopAppException;
import com.iplatform.security.util.LoginCallbackUtils;
import com.walker.web.CaptchaType;
import com.walker.web.ClientType;
import com.walker.web.LoginType;
import com.walker.web.ResponseCode;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DefaultAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private boolean allowPcUserAccessApp = true;
    private UserDetailsService userDetailsService;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        DefaultUserDetails defaultUserDetails;
        if (!(authentication instanceof DefaultAuthenticationToken)) {
            throw new InternalAuthenticationServiceException("UsernamePasswordAuthenticationToken \u5fc5\u987b\u662f: DefaultAuthenticationToken", null);
        }
        DefaultAuthenticationToken defaultAuthenticationToken = (DefaultAuthenticationToken)authentication;
        RequestLogin requestLogin = defaultAuthenticationToken.getRequestLogin();
        if (!this.allowPcUserAccessApp && requestLogin.getClientType().equalsIgnoreCase(ClientType.MOBILE.getIndex()) && ((S_user_core)(defaultUserDetails = (DefaultUserDetails)userDetails).getUserPrincipal().getUserInfo()).getUser_type() != 99) {
            throw new PcUserStopAppException(null);
        }
        CaptchaType captchaType = CaptchaType.getType((String)requestLogin.getVerifyType());
        PlatformLoginCallback loginCallback = LoginCallbackUtils.getLoginCallbackBean(LoginType.getType((String)requestLogin.getLoginType()), true, captchaType);
        if (loginCallback == null) {
            throw new InternalAuthenticationServiceException("loginCallback\u672a\u627e\u5230:" + requestLogin.getLoginType());
        }
        boolean success = loginCallback.validatePassword(((DefaultUserDetails)userDetails).getUserPrincipal());
        if (!success) {
            throw new BadCredentialsException(ResponseCode.USER_CREDENTIALS_ERROR.getMessage());
        }
        this.logger.debug((Object)("++++++++++++ \u81ea\u52a8\u9a8c\u8bc1\u5bc6\u7801\u4e3a\u6b63\u786e, loginType = " + requestLogin.getLoginType()));
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            UserDetails loadedUser = this.userDetailsService.loadUserByUsername(username);
            if (loadedUser == null) {
                throw new InternalAuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
            }
            return loadedUser;
        }
        catch (Exception ex) {
            if (ex instanceof UsernameNotFoundException) {
                this.logger.debug((Object)("+++++++++++++++ " + ex.getMessage()));
                throw ex;
            }
            if (ex instanceof InternalAuthenticationServiceException) {
                throw ex;
            }
            throw new InternalAuthenticationServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setAllowPcUserAccessApp(boolean allowPcUserAccessApp) {
        this.allowPcUserAccessApp = allowPcUserAccessApp;
    }
}

