/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.cache.MenuCacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import com.walker.web.security.ResourceLoadProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class DefaultResourceLoaderProvider
implements ResourceLoadProvider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private MenuCacheProvider menuCacheProvider = null;
    private Map<String, Collection<ConfigAttribute>> resultMap = new HashMap<String, Collection<ConfigAttribute>>();
    private Map<String, AntPathRequestMatcher> requestMatchers = new ConcurrentHashMap<String, AntPathRequestMatcher>();
    private Collection<ConfigAttribute> emptyAttributes = null;
    private Collection<ConfigAttribute> anonymousAttributes = null;
    private Collection<ConfigAttribute> activiti7Attributes = null;
    private List<String> permitAccessUrls = null;
    private Map<String, String> anonymousUrlMap = null;

    public void setAnonymousUrlList(List<String> anonymousUrlList) {
        if (!StringUtils.isEmptyList(anonymousUrlList)) {
            this.anonymousUrlMap = new HashMap<String, String>();
            for (String url : anonymousUrlList) {
                this.anonymousUrlMap.put(url, "");
            }
        }
    }

    public void setPermitAccessUrls(List<String> permitAccessUrls) {
        this.permitAccessUrls = permitAccessUrls;
    }

    public void setMenuCacheProvider(MenuCacheProvider menuCacheProvider) {
        SystemLogMan.getInstance().checkMan();
        this.menuCacheProvider = menuCacheProvider;
    }

    public Map<String, Collection<ConfigAttribute>> loadResource() {
        List allMenuUrl;
        this.resultMap.clear();
        this.requestMatchers.clear();
        HashMap<String, List<String>> urlRoleMap = new HashMap<String, List<String>>();
        List roleUrlMap = this.menuCacheProvider.getAllRoleMenuMap();
        if (roleUrlMap != null && roleUrlMap.size() > 0) {
            String url = null;
            for (String[] stringArray : roleUrlMap) {
                url = stringArray[1];
                if (StringUtils.isEmpty((String)url)) {
                    throw new NullPointerException("url is not null! role = " + stringArray[0]);
                }
                this.setUrlRoleMap(urlRoleMap, url, stringArray[0]);
            }
        }
        if (!StringUtils.isEmptyList((List)(allMenuUrl = this.menuCacheProvider.getAllMenuUrlList()))) {
            for (String string : allMenuUrl) {
                this.setUrlRoleMap(urlRoleMap, string, "ROLE_SUPERVISOR");
            }
        }
        this.setUrlRoleMap(urlRoleMap, "/supervisor/**", "ROLE_SUPERVISOR");
        this.setUrlRoleMap(urlRoleMap, "/permit/**", "ROLE_USER");
        if (!StringUtils.isEmptyList(this.permitAccessUrls)) {
            for (String string : this.permitAccessUrls) {
                this.setUrlRoleMap(urlRoleMap, string, "ROLE_USER");
            }
        }
        if (this.anonymousUrlMap != null) {
            for (String string : this.anonymousUrlMap.keySet()) {
                this.setUrlRoleMap(urlRoleMap, string, "ROLE_ANONYMOUS");
            }
        }
        this.setUrlRoleMap(urlRoleMap, "/wf/**", "ROLE_ACTIVITI_USER");
        this.logger.info("\u5171\u52a0\u8f7d\u6743\u9650\u70b9: " + urlRoleMap.size());
        if (urlRoleMap.size() > 0) {
            ArrayList<SecurityConfig> caList = null;
            for (Map.Entry entry : urlRoleMap.entrySet()) {
                caList = new ArrayList<SecurityConfig>(((List)entry.getValue()).size() + 1);
                for (String s : (List)entry.getValue()) {
                    SecurityConfig ca = new SecurityConfig(s);
                    caList.add(ca);
                }
                this.resultMap.put((String)entry.getKey(), caList);
            }
        }
        Iterator<String> it = this.resultMap.keySet().iterator();
        Object var5_14 = null;
        Object var6_18 = null;
        while (it.hasNext()) {
            String string = it.next();
            AntPathRequestMatcher antPathRequestMatcher = this.requestMatchers.get(string);
            if (antPathRequestMatcher != null) continue;
            AntPathRequestMatcher antPathRequestMatcher2 = new AntPathRequestMatcher(string);
            this.requestMatchers.put(string, antPathRequestMatcher2);
        }
        return this.resultMap;
    }

    public void reloadResource() {
        this.loadResource();
        this.logger.info("ResourceLoaderProvider reload success!");
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        if (this.resultMap == null) {
            return this.getEmptyAttributes();
        }
        Iterator<String> it = this.resultMap.keySet().iterator();
        String srcURL = null;
        String resURL = null;
        AntPathRequestMatcher requestMatcher = null;
        while (it.hasNext()) {
            resURL = it.next();
            requestMatcher = this.requestMatchers.get(resURL);
            if (requestMatcher == null) {
                requestMatcher = new AntPathRequestMatcher(resURL);
                this.requestMatchers.put(resURL, requestMatcher);
            }
            srcURL = ((FilterInvocation)object).getRequestUrl();
            if (!requestMatcher.matches(((FilterInvocation)object).getRequest())) continue;
            this.logger.debug("............> \u627e\u5230\u4e86\u5339\u914d\u7684\u8d44\u6e90: " + resURL + ", \u8bf7\u6c42\u7684\u8d44\u6e90: " + srcURL);
            if (resURL.startsWith("/wf/")) {
                this.logger.debug("\u8fd4\u56deactiviti7\u7684\u89d2\u8272\u96c6\u5408");
                return this.getActiviti7Attributes();
            }
            return this.resultMap.get(resURL);
        }
        if (this.anonymousUrlMap != null && this.anonymousUrlMap.get(srcURL) != null) {
            return this.getAnonymousAttributes();
        }
        return this.getEmptyAttributes();
    }

    public Collection<ConfigAttribute> getAttributesByUri(String uri) {
        return null;
    }

    private void setUrlRoleMap(Map<String, List<String>> urlRoleMap, String _url, String _roleId) {
        List<String> _roles = urlRoleMap.get(_url);
        if (_roles == null) {
            _roles = new ArrayList<String>(8);
            _roles.add(_roleId);
            urlRoleMap.put(_url, _roles);
        } else if (!_roles.contains(_roleId)) {
            _roles.add(_roleId);
        }
    }

    protected Collection<ConfigAttribute> getEmptyAttributes() {
        if (this.emptyAttributes == null) {
            this.emptyAttributes = new ArrayList<ConfigAttribute>(2);
            this.emptyAttributes.add((ConfigAttribute)new SecurityConfig("ROLE_EMPTY"));
        }
        return this.emptyAttributes;
    }

    protected Collection<ConfigAttribute> getAnonymousAttributes() {
        if (this.anonymousAttributes == null) {
            this.anonymousAttributes = new ArrayList<ConfigAttribute>(2);
            this.anonymousAttributes.add((ConfigAttribute)new SecurityConfig("ROLE_ANONYMOUS"));
        }
        return this.emptyAttributes;
    }

    protected Collection<ConfigAttribute> getActiviti7Attributes() {
        if (this.activiti7Attributes == null) {
            this.activiti7Attributes = new ArrayList<ConfigAttribute>(2);
            this.activiti7Attributes.add((ConfigAttribute)new SecurityConfig("ROLE_ACTIVITI_USER"));
        }
        return this.activiti7Attributes;
    }
}

