/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.AsyncManager;
import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.callback.AfterLoginCallback;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.base.config.LogProperties;
import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.base.service.LoginServiceImpl;
import com.iplatform.base.support.strategy.LoginStrategyManager;
import com.iplatform.base.util.TokenUtils;
import com.iplatform.base.util.UserUtils;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_login_info;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.po.S_user_login;
import com.iplatform.security.DefaultAuthenticationToken;
import com.iplatform.security.DefaultUserDetails;
import com.iplatform.security.config.SecurityProperties;
import com.iplatform.security.util.LoginCallbackUtils;
import com.iplatform.security.util.SecurityConfigUtils;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import com.walker.web.LoginType;
import com.walker.web.ResponseCode;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import com.walker.web.WebAgentService;
import com.walker.web.WebRuntimeException;
import com.walker.web.WebUserAgent;
import com.walker.web.util.IdUtils;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class DefaultSecuritySpi
implements SecuritySpi {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BEAN_NAME_CAPTCHA_CACHE = "captchaCacheProvider";

    public boolean isAllowMobileLoginRegister() {
        return this.getSecurityProperties().isAllowMobileLoginReg();
    }

    public Map<String, Object> login(RequestLogin requestLogin) throws LoginException {
        CaptchaType currentCaptchaType;
        String error;
        String username = requestLogin.getUsername();
        CaptchaType captchaType = CaptchaType.getType((String)requestLogin.getVerifyType());
        PlatformLoginCallback loginCallback = LoginCallbackUtils.getLoginCallbackBean(LoginType.getType((String)requestLogin.getLoginType()), true, captchaType);
        boolean captchaEnabled = this.getArgumentVariable("security.captcha.enabled").getBooleanValue();
        if (captchaEnabled) {
            CaptchaProvider captchaProvider = loginCallback.getCaptchaProvider();
            if (captchaProvider == null) {
                throw new LoginException("\u7cfb\u7edf\u9700\u8981\u9a8c\u8bc1\u7801\uff0c\u4f46\u767b\u5f55\u672a\u914d\u7f6e:" + loginCallback.getClass().getName());
            }
            if (StringUtils.isEmpty((String)requestLogin.getVerifyType())) {
                throw new LoginException("\u8bf7\u6c42\u9519\u8bef\uff1a\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (captchaProvider.getCaptchaType() != CaptchaType.ThirdParty && !requestLogin.getVerifyType().equals(captchaProvider.getCaptchaType().getIndex())) {
                throw new LoginException("\u524d\u7aef\u914d\u7f6e\u7684\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0e\u540e\u53f0\u4e0d\u4e00\u81f4! verifyType = " + captchaProvider.getCaptchaType());
            }
            if (loginCallback.isValidateCaptcha()) {
                this.logger.debug("\u9700\u8981\u9a8c\u8bc1\u7801\uff0cgetCaptchaType={}", (Object)loginCallback.getCaptchaProvider().getCaptchaType());
                String error2 = this.validateCaptcha(requestLogin.getCode(), requestLogin.getUuid(), (CaptchaProvider<CaptchaResult>)captchaProvider);
                if (error2 != null) {
                    throw new LoginException(error2);
                }
            }
        }
        if (this.getLogProperties().isLoginEnabled() && (error = this.getLoginStrategyManager().execute(requestLogin)) != null) {
            throw new LoginException(error);
        }
        Authentication authentication = null;
        try {
            DefaultAuthenticationToken authenticationToken = new DefaultAuthenticationToken(username, requestLogin.getPassword(), requestLogin);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            authentication = this.getAuthenticationManager().authenticate((Authentication)authenticationToken);
        }
        catch (Exception e) {
            this.recordLoginInfo(requestLogin.getUsername(), String.valueOf(ResponseCode.ERROR.getCode()), "\u767b\u5f55\u672a\u6210\u529f\u8ba4\u8bc1", 0L, null, null);
            if (e instanceof UsernameNotFoundException) {
                throw new LoginException("\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u505c\u7528\uff1a" + requestLogin.getUsername(), (Throwable)e, true);
            }
            if (e instanceof BadCredentialsException) {
                this.logger.debug("++++++++++++++++++ \u5bc6\u7801\u9519\u8bef");
                throw new LoginException(ResponseCode.USER_CREDENTIALS_ERROR.getMessage());
            }
            throw new LoginException(e.getMessage());
        }
        DefaultUserDetails userDetails = (DefaultUserDetails)authentication.getPrincipal();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(userDetails.getUserPrincipal().toString());
        }
        if ((currentCaptchaType = loginCallback.getCaptchaProvider().getCaptchaType()) == CaptchaType.None || currentCaptchaType == CaptchaType.ThirdParty) {
            requestLogin.setUuid(IdUtils.simpleUUID());
        }
        long expiredMinutes = SecurityConfigUtils.getTokenExpireMinutes(requestLogin.getClientType(), this.getSecurityProperties());
        String token = TokenUtils.generateToken((String)userDetails.getUserPrincipal().getId(), (String)userDetails.getUsername(), (String)requestLogin.getUuid(), (TokenGenerator)this.getTokenGenerator(), (long)expiredMinutes);
        this.logger.debug("token\u5931\u6548\u5206\u949f:{}", (Object)expiredMinutes);
        long loginCacheExpiredTime = 43200L;
        if (expiredMinutes > loginCacheExpiredTime) {
            loginCacheExpiredTime = expiredMinutes;
        }
        this.getUserOnlineProvider().cacheUserPrincipal(requestLogin.getUuid(), userDetails.getUserPrincipal(), loginCacheExpiredTime);
        this.logger.debug("\u767b\u5f55\u7528\u6237\u7f13\u5b58\u5931\u6548\u5206\u949f:{}", (Object)loginCacheExpiredTime);
        this.recordLoginInfo(username, String.valueOf(ResponseCode.SUCCESS.getCode()), "\u767b\u5f55\u6210\u529f", ((S_user_core)userDetails.getUserPrincipal().getUserInfo()).getId(), requestLogin.getUuid(), requestLogin.getClientType());
        AfterLoginCallback afterLoginCallback = (AfterLoginCallback)PlatformCallbackPostProcessor.getCallbackObject(AfterLoginCallback.class);
        if (afterLoginCallback != null) {
            afterLoginCallback.onSuccess(requestLogin, userDetails.getUserPrincipal());
        }
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("token", token);
        param.put("userInfo", UserUtils.acquireClientUserInfo((S_user_core)((S_user_core)userDetails.getUserPrincipal().getUserInfo()), (String)token));
        param.put("userInfoApp", userDetails.getUserPrincipal());
        return param;
    }

    private String validateCaptcha(String code, String uuid, CaptchaProvider<CaptchaResult> captchaProvider) {
        if (StringUtils.isEmpty((String)uuid) || StringUtils.isEmpty((String)code)) {
            return "\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801";
        }
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setUuid(uuid);
        captchaResult.setCode(code);
        boolean success = captchaProvider.validateCaptcha((Object)captchaResult);
        if (captchaProvider.getCaptchaType() != CaptchaType.SmsCode) {
            this.getCaptchaCacheProvider().removeCacheData("captcha_codes:" + uuid);
        }
        if (!success) {
            this.logger.error("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25: code = " + code);
            return "\u9a8c\u8bc1\u7801\u9519\u8bef";
        }
        return null;
    }

    private void recordLoginInfo(String loginId, String status, String message, long userId, String uuid, String clientType) {
        if (this.getLogProperties().isLoginEnabled()) {
            this.logger.debug("\u5f02\u6b65\u8bb0\u5f55\u767b\u5f55\u65e5\u5fd7\uff0c\u540e\u7eed\u8981\u8865\u5145:" + status + ", " + message);
            AsyncManager.me().execute(this.acquireLoginInfoTask(loginId, status, message, userId, uuid, clientType));
        }
    }

    private TimerTask acquireLoginInfoTask(final String loginId, final String status, final String message, final Long userId, final String uuid, final String clientType) {
        HttpServletRequest request = ServletUtils.getRequest();
        final WebUserAgent webUserAgent = this.getWebAgentService().getWebUserAgent(request.getHeader("User-Agent"), request);
        return new TimerTask(){

            @Override
            public void run() {
                S_login_info login_info = new S_login_info();
                login_info.setLogin_time(Long.valueOf(Long.parseLong(DateUtils.getDateTimeSecondForShow())));
                login_info.setUser_name(loginId);
                login_info.setMsg(message);
                login_info.setStatus(status);
                login_info.setInfo_id(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
                if (webUserAgent != null) {
                    login_info.setLogin_location(webUserAgent.getLocation());
                    login_info.setBrowser(webUserAgent.getBrowserName());
                    login_info.setIpaddr(webUserAgent.getIp());
                    login_info.setOs(webUserAgent.getOsName());
                }
                if (status.equals(String.valueOf(ResponseCode.SUCCESS.getCode()))) {
                    S_user_login user_login = null;
                    if (DefaultSecuritySpi.this.getLoginStrategyManager().hasUserLogin(loginId)) {
                        user_login = DefaultSecuritySpi.this.getLoginService().execUpdateUserLogin(userId.longValue(), loginId, uuid, clientType, login_info, true);
                        DefaultSecuritySpi.this.getLoginStrategyManager().updateUserLoginCache(user_login);
                    } else {
                        user_login = DefaultSecuritySpi.this.getLoginService().execUpdateUserLogin(userId.longValue(), loginId, uuid, clientType, login_info, false);
                        DefaultSecuritySpi.this.getLoginStrategyManager().putUserLoginCache(user_login);
                    }
                } else {
                    DefaultSecuritySpi.this.getLogService().execInsertLoginLog(login_info, userId);
                }
            }
        };
    }

    private AuthenticationManager getAuthenticationManager() {
        return (AuthenticationManager)BeanContextAware.getBeanByType(AuthenticationManager.class);
    }

    private TokenGenerator getTokenGenerator() {
        return (TokenGenerator)BeanContextAware.getBeanByType(TokenGenerator.class);
    }

    private CacheProvider<String> getCaptchaCacheProvider() {
        return (CacheProvider)BeanContextAware.getBeanByName((String)BEAN_NAME_CAPTCHA_CACHE);
    }

    private WebAgentService getWebAgentService() {
        return (WebAgentService)BeanContextAware.getBeanByType(WebAgentService.class);
    }

    private UserOnlineProvider getUserOnlineProvider() {
        return (UserOnlineProvider)BeanContextAware.getBeanByType(UserOnlineProvider.class);
    }

    private SecurityProperties getSecurityProperties() {
        return (SecurityProperties)BeanContextAware.getBeanByType(SecurityProperties.class);
    }

    private LogProperties getLogProperties() {
        return (LogProperties)BeanContextAware.getBeanByType(LogProperties.class);
    }

    private LoginServiceImpl getLoginService() {
        return (LoginServiceImpl)BeanContextAware.getBeanByType(LoginServiceImpl.class);
    }

    private LogServiceImpl getLogService() {
        return (LogServiceImpl)BeanContextAware.getBeanByType(LogServiceImpl.class);
    }

    private LoginStrategyManager getLoginStrategyManager() {
        return (LoginStrategyManager)BeanContextAware.getBeanByType(LoginStrategyManager.class);
    }

    @Deprecated
    public void loginAsWorkflowRole() {
        DefaultUserDetails userDetails = this.getCurrentUserDetails();
        userDetails.addGrantedAuthority("ROLE_ACTIVITI_USER");
        this.logger.debug("......loginAsWorkflowRole(), {}", userDetails.getRoleIdList());
    }

    public List<String> getCurrentUserRoleIdList() {
        DefaultUserDetails userDetails = this.getCurrentUserDetails();
        if (userDetails == null) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u9519\u8bef\uff1agetCurrentUserDetails() == null");
            return null;
        }
        return userDetails.getRoleIdList();
    }

    public UserPrincipal<S_user_core> getCurrentUserPrincipal() {
        DefaultUserDetails userDetails = this.getCurrentUserDetails();
        if (userDetails == null) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u9519\u8bef\uff1agetCurrentUserDetails() == null");
            return null;
        }
        return userDetails.getUserPrincipal();
    }

    public S_user_core getCurrentUser() {
        UserPrincipal<S_user_core> userPrincipal = this.getCurrentUserPrincipal();
        if (userPrincipal == null) {
            throw new WebRuntimeException("\u5f53\u524d\u64cd\u4f5c\u672a\u627e\u5230\u767b\u5f55\u4eba\u5458: userPrincipal not found in thread!");
        }
        return (S_user_core)userPrincipal.getUserInfo();
    }

    public long getCurrentUserId() {
        S_user_core user = this.getCurrentUser();
        return user.getId();
    }

    public String encryptPassword(String password) {
        PasswordEncoder passwordEncoder = (PasswordEncoder)BeanContextAware.getBeanByType(PasswordEncoder.class);
        return passwordEncoder.encode((CharSequence)password);
    }

    public boolean matchesPassword(String rawPassword, String encodedPassword) {
        PasswordEncoder passwordEncoder = (PasswordEncoder)BeanContextAware.getBeanByType(PasswordEncoder.class);
        return passwordEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }

    private DefaultUserDetails getCurrentUserDetails() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            throw new WebRuntimeException("\u5f53\u524d\u64cd\u4f5c\u672a\u627e\u5230\u767b\u5f55\u8ba4\u8bc1\u5bf9\u8c61: authentication not found in thread!");
        }
        Object userDetails = authentication.getPrincipal();
        if (userDetails instanceof DefaultUserDetails) {
            return (DefaultUserDetails)userDetails;
        }
        return null;
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private Variable getArgumentVariable(String key) {
        Variable v = ((ArgumentsManager)BeanContextAware.getBeanByType(ArgumentsManager.class)).getVariable(key);
        if (v == null) {
            throw new IllegalArgumentException("\u53ef\u53d8\u914d\u7f6e\u53c2\u6570\u4e0d\u5b58\u5728: " + key);
        }
        return v;
    }
}

