/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.util.TokenUtils;
import com.iplatform.core.TokenAwareContext;
import com.iplatform.core.TokenEntity;
import com.iplatform.model.po.S_user_core;
import com.iplatform.security.DefaultUserDetails;
import com.iplatform.security.DefaultUserDetailsService;
import com.iplatform.security.config.SecurityProperties;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.web.ResponseCode;
import com.walker.web.ResponseValue;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TokenGenerator tokenGenerator;
    private UserOnlineProvider userOnlineProvider;
    private DefaultUserDetailsService defaultUserDetailsService;
    private SecurityProperties securityProperties;

    public void setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public void setDefaultUserDetailsService(DefaultUserDetailsService defaultUserDetailsService) {
        this.defaultUserDetailsService = defaultUserDetailsService;
    }

    public void setUserOnlineProvider(UserOnlineProvider userOnlineProvider) {
        this.userOnlineProvider = userOnlineProvider;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = TokenUtils.getAuthorizationToken((HttpServletRequest)request);
        if (token != null) {
            try {
                String data = this.tokenGenerator.validateToken(token, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB");
                this.logger.debug("token_data = " + data);
                String[] userIdAndKey = TokenUtils.getUserIdAndKey((String)data);
                if (userIdAndKey == null || userIdAndKey.length != 3) {
                    throw new ApplicationRuntimeException("token\u643a\u5e26\u7528\u6237\u4fe1\u606f\u89e3\u6790\u9519\u8bef:" + data);
                }
                String uuid = userIdAndKey[2];
                String loginId = userIdAndKey[1];
                DefaultUserDetails userDetails = null;
                DefaultUserPrincipal userPrincipal = this.acquireAuthenticationUser(uuid);
                if (userPrincipal == null) {
                    userDetails = this.defaultUserDetailsService.acquireUserPrincipal(loginId);
                    if (userDetails == null) {
                        this.userOnlineProvider.removeUserPrincipal(uuid);
                        this.logger.warn("\u7528\u6237\u5df2\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u767b\u5f55\u72b6\u6001\u7f13\u5b58\uff1a{}", (Object)uuid);
                        return;
                    }
                    userPrincipal = (DefaultUserPrincipal)userDetails.getUserPrincipal();
                    this.logger.debug("token\u9700\u8981\u5237\u65b0: " + userPrincipal.getUserName());
                    this.tellClientRefreshToken(response, uuid, userPrincipal);
                } else {
                    userDetails = this.acquireUserDetails((UserPrincipal<S_user_core>)userPrincipal);
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                TokenAwareContext.setCurrentToken((TokenEntity)new TokenEntity(uuid, loginId));
            }
            catch (TokenException ex) {
                if (ex.isExpired()) {
                    ServletUtils.renderString((HttpServletResponse)response, (ResponseValue)ResponseValue.error((int)ResponseCode.RE_LOGIN.getCode(), (String)"token\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6"));
                    return;
                }
                System.out.println(ex.getTitle());
                ServletUtils.renderString((HttpServletResponse)response, (ResponseValue)ResponseValue.error((int)ResponseCode.ERROR.getCode(), (String)ex.getTitle()));
                return;
            }
            catch (Exception ex) {
                this.logger.error("\u6839\u636etoken\u83b7\u5f97\u767b\u5f55\u4fe1\u606f\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
                ServletUtils.renderString((HttpServletResponse)response, (ResponseValue)ResponseValue.error((int)ResponseCode.ERROR.getCode(), (String)ex.getMessage()));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        TokenAwareContext.clearCurrentToken();
    }

    private void tellClientRefreshToken(HttpServletResponse response, String uuid, DefaultUserPrincipal userPrincipal) {
        String token = TokenUtils.generateToken((String)userPrincipal.getId(), (String)userPrincipal.getUserName(), (String)uuid, (TokenGenerator)this.tokenGenerator, (long)this.securityProperties.getTokenExpireWeb());
        userPrincipal.setLastLoginTime(System.currentTimeMillis());
        this.userOnlineProvider.cacheUserPrincipal(uuid, (UserPrincipal)userPrincipal, this.securityProperties.getTokenExpireWeb());
        response.addHeader("TokenRefresh", token);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5237\u65b0token, uuid = " + uuid + ", " + token);
        }
    }

    private DefaultUserDetails acquireUserDetails(UserPrincipal<S_user_core> userPrincipal) {
        DefaultUserDetails userDetails = new DefaultUserDetails(userPrincipal);
        if (userDetails.isSupervisor()) {
            userDetails.addGrantedAuthority("ROLE_SUPERVISOR");
            userDetails.addGrantedAuthority("ROLE_ADMIN");
            userDetails.addGrantedAuthority("ROLE_USER");
        } else {
            List roleIdList = userPrincipal.getRoleIdList();
            this.logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6 userPrincipal.getRoleIdList() = " + roleIdList);
            if (roleIdList != null) {
                for (String roleId : roleIdList) {
                    userDetails.addGrantedAuthority(roleId);
                }
            }
        }
        return userDetails;
    }

    private DefaultUserPrincipal acquireAuthenticationUser(String uuid) {
        return (DefaultUserPrincipal)this.userOnlineProvider.getUserPrincipal(uuid);
    }
}

