/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security.config;

import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.captcha.JigsawCaptchaProvider;
import com.iplatform.base.captcha.NoneCaptchaProvider;
import com.iplatform.base.captcha.ThirdPartyCaptchaProvider;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.UserUtils;
import com.iplatform.core.PlatformConfiguration;
import com.iplatform.model.po.S_user_core;
import com.iplatform.security.DefaultAuthenticationFailureHandler;
import com.iplatform.security.DefaultAuthenticationProvider;
import com.iplatform.security.DefaultLogoutSuccessHandler;
import com.iplatform.security.DefaultResourceLoaderProvider;
import com.iplatform.security.DefaultUserDetailsService;
import com.iplatform.security.FailedAuthenticationEntryPoint;
import com.iplatform.security.JwtAuthenticationTokenFilter;
import com.iplatform.security.callback.EncryptPasswordLoginCallback;
import com.iplatform.security.callback.MobilePassCaptchaLoginCallback;
import com.iplatform.security.callback.NoneCaptchaLoginCallback;
import com.iplatform.security.callback.SmsCodeLoginCallback;
import com.iplatform.security.callback.ThirdPartyLoginCallback;
import com.iplatform.security.callback.WechatLoginCallback;
import com.iplatform.security.config.SecurityProperties;
import com.iplatform.security.event.RoleSecurityUpdateListener;
import com.iplatform.security.util.SecurityConfigUtils;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import com.walker.web.security.DefaultAccessDecisionManager;
import com.walker.web.security.DefaultAccessDeniedHandler;
import com.walker.web.security.DefaultSecurityMetadataSource;
import com.walker.web.security.ResourceLoadProvider;
import com.walker.web.token.JwtTokenGenerator;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class WebSecurityConfig
extends PlatformConfiguration {
    private MenuCacheProvider menuCacheProvider;
    private UserServiceImpl userService;
    private UserOnlineProvider userOnlineProvider;
    private UserCacheProvider userCacheProvider;
    private UserLoginCache userLoginCache;

    @Autowired
    public WebSecurityConfig(MenuCacheProvider menuCacheProvider, UserServiceImpl userService, UserOnlineProvider userOnlineProvider, UserCacheProvider userCacheProvider, UserLoginCache userLoginCache) {
        this.menuCacheProvider = menuCacheProvider;
        this.userService = userService;
        this.userOnlineProvider = userOnlineProvider;
        this.userCacheProvider = userCacheProvider;
        SystemLogMan.getInstance().checkMan();
        this.userLoginCache = userLoginCache;
    }

    @Bean
    public SecurityProperties securityProperties() {
        return new SecurityProperties();
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        DefaultUserDetailsService userDetailsService = this.userDetailsService(this.securityProperties(), this.userCacheProvider);
        http.userDetailsService((UserDetailsService)userDetailsService);
        http.csrf(csrf -> csrf.disable());
        http.headers(headersCustomizer -> headersCustomizer.frameOptions(frameOptionsConfig -> frameOptionsConfig.disable()));
        http.formLogin(formLogin -> formLogin.disable());
        http.httpBasic(h -> h.disable());
        http.exceptionHandling(configurer -> configurer.authenticationEntryPoint(this.failedAuthenticationEntryPoint()).accessDeniedHandler(this.accessDeniedHandler())).sessionManagement(s -> s.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        http.logout(configure -> configure.logoutUrl("/logout").logoutSuccessHandler(this.logoutSuccessHandler()).permitAll());
        List<String> anonymousList = this.securityProperties().getAnonymousList();
        if (!StringUtils.isEmptyList(anonymousList)) {
            http.authorizeHttpRequests(configure -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)configure.requestMatchers(anonymousList.toArray(new String[0]))).permitAll());
        }
        http.authenticationProvider((AuthenticationProvider)this.authenticationProvider(userDetailsService, this.securityProperties()));
        http.authorizeHttpRequests(request -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)request.anyRequest()).authenticated());
        http.addFilterBefore((Filter)this.securityInterceptor(), FilterSecurityInterceptor.class);
        http.addFilterBefore((Filter)this.jwtAuthenticationTokenFilter(userDetailsService), UsernamePasswordAuthenticationFilter.class);
        if (this.securityProperties().isCorsEnabled()) {
            http.addFilterBefore((Filter)this.corsFilter(), JwtAuthenticationTokenFilter.class);
            http.addFilterBefore((Filter)this.corsFilter(), LogoutFilter.class);
        } else {
            System.out.println("\u4e0d\u6dfb\u52a0\u8de8\u57df\u8fc7\u6ee4\u5668: ");
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    public DefaultUserDetailsService userDetailsService(SecurityProperties securityProperties, UserCacheProvider userCacheProvider) {
        DefaultUserDetailsService userDetailsService = new DefaultUserDetailsService();
        userDetailsService.setUserService(this.userService);
        userDetailsService.setSecurityProperties(securityProperties);
        userDetailsService.setMenuCacheProvider(this.menuCacheProvider);
        System.out.println("create UserDetailsService = " + userDetailsService);
        UserPrincipal userPrincipal = UserUtils.createSupervisor((String)securityProperties.getSupervisorPassword());
        userCacheProvider.putUser((S_user_core)userPrincipal.getUserInfo());
        return userDetailsService;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationEntryPoint failedAuthenticationEntryPoint() {
        return new FailedAuthenticationEntryPoint();
    }

    @Bean
    public AccessDeniedHandler accessDeniedHandler() {
        return new DefaultAccessDeniedHandler();
    }

    @Bean
    public AuthenticationFailureHandler authenticationFailureHandler() {
        return new DefaultAuthenticationFailureHandler();
    }

    @Bean
    public LogoutSuccessHandler logoutSuccessHandler() {
        DefaultLogoutSuccessHandler logoutSuccessHandler = new DefaultLogoutSuccessHandler();
        logoutSuccessHandler.setUserOnlineProvider(this.userOnlineProvider);
        logoutSuccessHandler.setTokenGenerator(this.tokenGenerator());
        logoutSuccessHandler.setUserLoginCache(this.userLoginCache);
        return logoutSuccessHandler;
    }

    @Bean
    public AccessDecisionManager accessDecisionManager() {
        return new DefaultAccessDecisionManager();
    }

    @Bean
    public DefaultSecurityMetadataSource securityMetadataSource(ResourceLoadProvider resourceLoadProvider) {
        DefaultSecurityMetadataSource securityMetadataSource = new DefaultSecurityMetadataSource();
        securityMetadataSource.setResourceLoaderProvider(resourceLoadProvider);
        return securityMetadataSource;
    }

    @Bean
    public FilterSecurityInterceptor securityInterceptor() {
        FilterSecurityInterceptor securityInterceptor = new FilterSecurityInterceptor();
        securityInterceptor.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)this.securityMetadataSource(this.resourceLoadProvider()));
        securityInterceptor.setAccessDecisionManager(this.accessDecisionManager());
        this.logger.info("\u521b\u5efa\uff1aFilterSecurityInterceptor");
        return securityInterceptor;
    }

    @Bean
    public JwtAuthenticationTokenFilter jwtAuthenticationTokenFilter(DefaultUserDetailsService userDetailsService) {
        JwtAuthenticationTokenFilter jwtAuthenticationTokenFilter = new JwtAuthenticationTokenFilter();
        jwtAuthenticationTokenFilter.setTokenGenerator(this.tokenGenerator());
        jwtAuthenticationTokenFilter.setUserOnlineProvider(this.userOnlineProvider);
        jwtAuthenticationTokenFilter.setDefaultUserDetailsService(userDetailsService);
        jwtAuthenticationTokenFilter.setSecurityProperties(this.securityProperties());
        return jwtAuthenticationTokenFilter;
    }

    @Bean
    public TokenGenerator tokenGenerator() {
        return new JwtTokenGenerator();
    }

    @Bean
    public WechatLoginCallback wechatLoginCallback(PasswordEncoder passwordEncoder, TokenGenerator tokenGenerator) {
        WechatLoginCallback callback = new WechatLoginCallback();
        callback.setTokenGenerator(tokenGenerator);
        callback.setPasswordEncoder(passwordEncoder);
        callback.setCaptchaProvider((CaptchaProvider)new NoneCaptchaProvider());
        return callback;
    }

    @Bean
    public ThirdPartyLoginCallback thirdPartyLoginCallback(PasswordEncoder passwordEncoder, TokenGenerator tokenGenerator) {
        ThirdPartyLoginCallback callback = new ThirdPartyLoginCallback();
        callback.setTokenGenerator(tokenGenerator);
        callback.setPasswordEncoder(passwordEncoder);
        callback.setCaptchaProvider((CaptchaProvider)new ThirdPartyCaptchaProvider());
        return callback;
    }

    @Bean
    public MobilePassCaptchaLoginCallback mobilePassCaptchaLoginCallback(PasswordEncoder passwordEncoder, TokenGenerator tokenGenerator, SecurityProperties securityProperties, CaptchaProvider<CaptchaResult> smsCaptchaProvider, CaptchaProvider<CaptchaResult> imageCaptchaProvider, JigsawCaptchaProvider jigsawCaptchaProvider) {
        MobilePassCaptchaLoginCallback loginCallback = new MobilePassCaptchaLoginCallback();
        loginCallback.setTokenGenerator(tokenGenerator);
        loginCallback.setPasswordEncoder(passwordEncoder);
        CaptchaProvider<CaptchaResult> captchaProvider = SecurityConfigUtils.findCaptchaProvider(securityProperties.getLoginCaptchaUserPass(), smsCaptchaProvider, imageCaptchaProvider, jigsawCaptchaProvider);
        loginCallback.setCaptchaProvider(captchaProvider);
        return loginCallback;
    }

    @Bean
    public NoneCaptchaLoginCallback noneCaptchaPasswordLoginCallback(PasswordEncoder passwordEncoder, TokenGenerator tokenGenerator) {
        NoneCaptchaLoginCallback encryptPasswordLoginCallback = new NoneCaptchaLoginCallback();
        encryptPasswordLoginCallback.setTokenGenerator(tokenGenerator);
        encryptPasswordLoginCallback.setPasswordEncoder(passwordEncoder);
        encryptPasswordLoginCallback.setCaptchaProvider((CaptchaProvider)new NoneCaptchaProvider());
        return encryptPasswordLoginCallback;
    }

    @Bean
    public EncryptPasswordLoginCallback captchaPasswordLoginCallback(TokenGenerator tokenGenerator, PasswordEncoder passwordEncoder, SecurityProperties securityProperties, CaptchaProvider<CaptchaResult> smsCaptchaProvider, CaptchaProvider<CaptchaResult> imageCaptchaProvider, JigsawCaptchaProvider jigsawCaptchaProvider) {
        EncryptPasswordLoginCallback webLoginCallback = new EncryptPasswordLoginCallback();
        webLoginCallback.setTokenGenerator(tokenGenerator);
        webLoginCallback.setUserOnlineProvider(this.userOnlineProvider);
        webLoginCallback.setUserService(this.userService);
        webLoginCallback.setPasswordEncoder(passwordEncoder);
        CaptchaProvider<CaptchaResult> captchaProvider = SecurityConfigUtils.findCaptchaProvider(securityProperties.getLoginCaptchaUserPass(), smsCaptchaProvider, imageCaptchaProvider, jigsawCaptchaProvider);
        webLoginCallback.setCaptchaProvider(captchaProvider);
        return webLoginCallback;
    }

    @Bean
    public SmsCodeLoginCallback smsCodeLoginCallback(TokenGenerator tokenGenerator, CacheProvider<String> captchaCacheProvider, SecurityProperties securityProperties, CaptchaProvider<CaptchaResult> smsCaptchaProvider, CaptchaProvider<CaptchaResult> imageCaptchaProvider, JigsawCaptchaProvider jigsawCaptchaProvider) {
        SmsCodeLoginCallback smsCodeLoginCallback = new SmsCodeLoginCallback();
        smsCodeLoginCallback.setTokenGenerator(tokenGenerator);
        smsCodeLoginCallback.setUserOnlineProvider(this.userOnlineProvider);
        smsCodeLoginCallback.setUserService(this.userService);
        smsCodeLoginCallback.setCaptchaCacheProvider(captchaCacheProvider);
        CaptchaProvider<CaptchaResult> captchaProvider = SecurityConfigUtils.findCaptchaProvider(securityProperties.getLoginCaptchaSmsCode(), smsCaptchaProvider, imageCaptchaProvider, jigsawCaptchaProvider);
        smsCodeLoginCallback.setCaptchaProvider(captchaProvider);
        return smsCodeLoginCallback;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (!this.securityProperties().isCorsEnabled()) {
            return new CorsFilter((CorsConfigurationSource)source);
        }
        source.registerCorsConfiguration("/**", this.buildConfig());
        System.out.println("\u914d\u7f6e\u8de8\u57df\u8fc7\u6ee4\u5668\uff0cthis.securityProperties().isCorsEnabled() = true");
        return new CorsFilter((CorsConfigurationSource)source);
    }

    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.addExposedHeader("*");
        return corsConfiguration;
    }

    @Bean
    public DefaultAuthenticationProvider authenticationProvider(UserDetailsService userDetailsService, SecurityProperties securityProperties) {
        DefaultAuthenticationProvider authenticationProvider = new DefaultAuthenticationProvider();
        authenticationProvider.setUserDetailsService(userDetailsService);
        System.out.println("isAllowPcUserAccessApp = " + securityProperties.isAllowPcUserAccessApp());
        authenticationProvider.setAllowPcUserAccessApp(securityProperties.isAllowPcUserAccessApp());
        authenticationProvider.setHideUserNotFoundExceptions(false);
        return authenticationProvider;
    }

    @Bean
    public ResourceLoadProvider resourceLoadProvider() {
        DefaultResourceLoaderProvider resourceLoaderProvider = new DefaultResourceLoaderProvider();
        resourceLoaderProvider.setMenuCacheProvider(this.menuCacheProvider);
        resourceLoaderProvider.setPermitAccessUrls(this.securityProperties().getPermitList());
        resourceLoaderProvider.setAnonymousUrlList(this.securityProperties().getAnonymousList());
        resourceLoaderProvider.loadResource();
        return resourceLoaderProvider;
    }

    @Bean
    public RoleSecurityUpdateListener roleSecurityUpdateListener(ResourceLoadProvider resourceLoadProvider) {
        RoleSecurityUpdateListener listener = new RoleSecurityUpdateListener();
        listener.setResourceLoaderProvider(resourceLoadProvider);
        return listener;
    }
}

