/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security.controller;

import com.iplatform.base.SecuritySpi;
import com.iplatform.base.SystemController;
import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.callback.SecurityCallback;
import com.iplatform.base.config.SecurityUserProperties;
import com.iplatform.base.config.TcpProperties;
import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.base.service.MenuServiceImpl;
import com.iplatform.base.util.menu.MenuTree;
import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.vo.MenuVo;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.UserPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SecurityController
extends SystemController {
    private MenuServiceImpl menuService;
    private MenuCacheProvider menuCacheProvider;
    private TcpProperties tcpProperties;
    private SecuritySpi securitySpi;
    private SecurityUserProperties securityUserProperties;

    @Autowired
    public SecurityController(MenuServiceImpl menuService, MenuCacheProvider menuCacheProvider, TcpProperties tcpProperties, SecuritySpi securitySpi, SecurityUserProperties securityUserProperties) {
        this.menuService = menuService;
        this.menuCacheProvider = menuCacheProvider;
        this.tcpProperties = tcpProperties;
        this.securitySpi = securitySpi;
        this.securityUserProperties = securityUserProperties;
    }

    @PostMapping(value={"/login"})
    public ResponseValue login(@RequestBody String raw) {
        this.logger.debug("login = " + raw);
        RequestLogin requestLogin = null;
        try {
            requestLogin = (RequestLogin)JsonUtils.jsonStringToObject((String)raw, RequestLogin.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String username = requestLogin.getUsername();
        String password = requestLogin.getPassword();
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\u6216\u5bc6\u7801");
        }
        Map param = null;
        try {
            param = this.securitySpi.login(requestLogin);
            return ResponseValue.success((Object)param);
        }
        catch (LoginException e) {
            return ResponseValue.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/getInfo"})
    public ResponseValue getUserInfo() {
        UserPrincipal userPrincipal = this.getCurrentUserPrincipal();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        SecurityCallback securityCallback = (SecurityCallback)this.getPlatformCallback(SecurityCallback.class);
        HashSet<String> perms = new HashSet<String>();
        if (((S_user_core)userPrincipal.getUserInfo()).getUser_type() == 0) {
            perms.add("*:*:*");
        } else {
            List menuIdList = this.menuService.queryRoleMenuIdList(userPrincipal.getRoleIdList());
            if (securityCallback == null) {
                int menuScope = this.getDeptCacheProvider().getDept(((S_user_core)userPrincipal.getUserInfo()).getOrg_id().longValue()).getMenu_type();
                if (menuScope == 0) {
                    perms.addAll(this.menuCacheProvider.getPermissionSet(menuIdList, false, menuScope));
                } else {
                    perms.addAll(this.menuCacheProvider.getPermissionSet(null, true, menuScope));
                }
            } else {
                this.logger.debug("\u5b58\u5728\u4e1a\u52a1\u81ea\u5b9a\u4e49\u6743\u9650\u56de\u8c03\uff1a{}", (Object)securityCallback.getClass().getName());
                Set userPermission = securityCallback.loadUserPermission((S_user_core)userPrincipal.getUserInfo(), menuIdList);
                if (userPermission != null) {
                    perms.addAll(userPermission);
                }
            }
        }
        this.logger.debug("\u7528\u6237 permissions = " + perms);
        data.put("roles", userPrincipal.getRoleIdList());
        data.put("permissions", perms);
        data.put("isPerfectInfo", true);
        if (this.securityUserProperties.isPassDefaultModify()) {
            data.put("force_change_pass", ((S_user_core)userPrincipal.getUserInfo()).getModify_pwd() != 1);
        } else {
            data.put("force_change_pass", false);
        }
        S_user_core user = (S_user_core)userPrincipal.getUserInfo();
        data.put("id", user.getId());
        data.put("account", user.getUser_name());
        data.put("realName", user.getNick_name());
        data.put("roleNames", null);
        data.put("roleIds", StringUtils.collectionToCommaDelimitedString((Collection)userPrincipal.getRoleIdList()));
        data.put("phone", user.getPhonenumber());
        data.put("isSms", true);
        data.put("merStarLevel", 0);
        if (!this.tcpProperties.isEnabled()) {
            this.logger.warn("\u672a\u5f00\u542f'WebSocket'");
            data.put("uri", "-1");
        } else {
            data.put("uri", this.tcpProperties.getWebsocketUri());
            data.put("uid", userPrincipal.getId());
        }
        if (securityCallback != null) {
            securityCallback.acquireUserInfo(data, user);
        }
        return ResponseValue.success(data);
    }

    @Deprecated
    @GetMapping(value={"/getRouters"})
    public ResponseValue getRouters() {
        List<SystemMenu> menuList = this.acquireUserMenuList();
        List routerList = this.menuCacheProvider.buildMenus(menuList);
        return ResponseValue.success((Object)routerList);
    }

    @GetMapping(value={"/getMenus"})
    public ResponseValue getMenus() {
        List<SystemMenu> menuList = this.acquireUserMenuList();
        List<MenuVo> menuVoList = new ArrayList(32);
        if (menuList != null) {
            MenuVo menuVo = null;
            for (SystemMenu menu : menuList) {
                if (menu.getMenu_type().equals("F")) continue;
                menuVo = new MenuVo();
                menuVo.setId(Long.valueOf(Long.parseLong(menu.getMenu_id())));
                menuVo.setPid(Long.valueOf(Long.parseLong(menu.getParent_id())));
                menuVo.setName(menu.getMenu_name());
                menuVo.setPerms(menu.getPerms());
                menuVo.setComponent(menu.getComponent());
                menuVo.setSort(menu.getOrder_num());
                menuVo.setIcon(menu.getIcon());
                menuVo.setMenuType(menu.getMenu_type());
                if (StringUtils.isNotEmpty((String)menu.getIcon_info())) {
                    String[] customIcons = StringUtils.commaDelimitedListToStringArray((String)menu.getIcon_info());
                    if (customIcons.length != 2) {
                        throw new IllegalArgumentException("\u81ea\u5b9a\u4e49\u83dc\u5355\u56fe\u6807(\u76f8\u5bf9\u8def\u5f84)\u5fc5\u987b\u914d\u7f6e\u4e24\u4e2a\uff0c\u5e76\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\uff0cname=" + menu.getMenu_name());
                    }
                    menuVo.setIconNormal(customIcons[0]);
                    menuVo.setIconActive(customIcons[1]);
                }
                menuVoList.add(menuVo);
            }
        }
        MenuTree menuTree = new MenuTree(menuVoList);
        menuVoList = menuTree.buildTree();
        return ResponseValue.success(menuVoList);
    }

    private List<SystemMenu> acquireUserMenuList() {
        List menuList = null;
        UserPrincipal userPrincipal = this.getCurrentUserPrincipal();
        SecurityCallback securityCallback = (SecurityCallback)this.getPlatformCallback(SecurityCallback.class);
        if (securityCallback == null) {
            int menuScope;
            menuList = ((S_user_core)userPrincipal.getUserInfo()).getUser_type() == 0 ? this.menuCacheProvider.getMenuList(null, 0) : ((menuScope = this.getDeptCacheProvider().getDept(((S_user_core)userPrincipal.getUserInfo()).getOrg_id().longValue()).getMenu_type().intValue()) == 0 ? this.menuCacheProvider.getMenuList(userPrincipal.getRoleIdList(), menuScope) : this.menuCacheProvider.getMenuList(null, menuScope));
        } else {
            menuList = securityCallback.loadUserMenu((S_user_core)userPrincipal.getUserInfo(), userPrincipal.getRoleIdList());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5b58\u5728\u4e1a\u52a1\u81ea\u5b9a\u4e49\u83dc\u5355\u56de\u8c03\uff1a{}", (Object)menuList);
            }
        }
        if (menuList != null) {
            SystemMenu menu = null;
            Iterator it = menuList.iterator();
            while (it.hasNext()) {
                menu = (SystemMenu)it.next();
                if (!menu.getMenu_type().equals("F") && !menu.getStatus().equals(1) && !menu.getVisible().equals("1")) continue;
                it.remove();
            }
        }
        return menuList;
    }
}

