/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security.util;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.security.callback.EncryptPasswordLoginCallback;
import com.iplatform.security.callback.MobilePassCaptchaLoginCallback;
import com.iplatform.security.callback.NoneCaptchaLoginCallback;
import com.iplatform.security.callback.SimplePasswordLoginCallback;
import com.iplatform.security.callback.SmsCodeLoginCallback;
import com.iplatform.security.callback.ThirdPartyLoginCallback;
import com.iplatform.security.callback.WechatLoginCallback;
import com.walker.web.CaptchaType;
import com.walker.web.LoginType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCallbackUtils {
    protected static final Logger logger = LoggerFactory.getLogger(LoginCallbackUtils.class);

    public static final PlatformLoginCallback getLoginCallbackBean(LoginType loginType, boolean encryptPassword, CaptchaType captchaType) {
        if (loginType == LoginType.UserPassword) {
            if (encryptPassword) {
                return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(EncryptPasswordLoginCallback.class);
            }
            logger.error("'SimplePasswordLoginCallback'\u8fd8\u672a\u914d\u7f6e\uff0c\u660e\u6587\u5bc6\u7801\u767b\u5f55\u5df2\u4e0d\u518d\u652f\u6301\uff01\u4ec5\u7528\u4e8e\u6d4b\u8bd5\u3002");
            return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(SimplePasswordLoginCallback.class);
        }
        if (loginType == LoginType.SmsCode) {
            return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(SmsCodeLoginCallback.class);
        }
        if (loginType == LoginType.MobilePassword) {
            if (captchaType == CaptchaType.None) {
                return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(NoneCaptchaLoginCallback.class);
            }
            return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(MobilePassCaptchaLoginCallback.class);
        }
        if (loginType == LoginType.ThirdParty) {
            return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(ThirdPartyLoginCallback.class);
        }
        if (loginType == LoginType.Wechat) {
            return (PlatformLoginCallback)PlatformCallbackPostProcessor.getCallbackMultipleBean(WechatLoginCallback.class);
        }
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u767b\u5f55\u7c7b\u578b:" + loginType);
    }
}

