package com.iplatform.tcp.client;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.tcp.websocket.HelloRequest;
import org.java_websocket.client.WebSocketClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.RequestMapping;

@SpringBootApplication(scanBasePackages = {"com.walker","com.iplatform"})
public class ClientApplication {

    @Autowired
    private WebSocketClient webSocketClient;

    public static void main(String[] args) throws Exception{
        SpringApplication.run(ClientApplication.class, args);

//        TimeUnit.SECONDS.sleep(3);
//        TextSimilarityEngine textSimilarityEngine = BeanContextAware.getBeanByType(TextSimilarityEngine.class);
//        textSimilarityEngine.dropTable("course_info");
//        System.out.println("drop table: course_info");
//
//        WaitConsoleInput.waitInput();
    }

    @RequestMapping("/send")
    public String send(String name){
        HelloRequest request = new HelloRequest();
        request.setMessageId("messageId:hello");
        request.setName(name);

        try {
            String data = JsonUtils.objectToJsonString(request);
            webSocketClient.send(data.getBytes());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "发送成功";
    }

}
