/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.client.config;

import com.iplatform.tcp.client.config.ClientProperties;
import com.walker.infrastructure.utils.JsonUtils;
import java.net.URI;
import java.util.HashMap;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebSocketClientConfig {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebSocketClient webSocketClient = null;

    @Bean
    public ClientProperties clientProperties() {
        return new ClientProperties();
    }

    @Bean
    public WebSocketClient webSocketClient(final ClientProperties properties) {
        try {
            this.webSocketClient = new WebSocketClient(new URI(properties.getUrl()), (Draft)new Draft_6455()){

                public void onOpen(ServerHandshake handshake) {
                    WebSocketClientConfig.this.logger.info("ws \u8fde\u63a5\u6210\u529f");
                    String data = null;
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    map.put("protocol", "login");
                    map.put("uid", properties.getName());
                    try {
                        data = JsonUtils.objectToJsonString(map);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    WebSocketClientConfig.this.webSocketClient.send(data.getBytes());
                    WebSocketClientConfig.this.logger.info("\u5ba2\u6237\u7aef\u53d1\u9001\u767b\u5f55\u8bf7\u6c42\uff0cname = {}", (Object)properties.getName());
                }

                public void onMessage(String message) {
                    WebSocketClientConfig.this.logger.info("ws \u6536\u5230\u6d88\u606f" + message);
                }

                public void onClose(int code, String reason, boolean remote) {
                    WebSocketClientConfig.this.logger.info("ws \u9000\u51fa");
                }

                public void onError(Exception ex) {
                    ex.printStackTrace();
                    WebSocketClientConfig.this.logger.info("\u8fde\u63a5\u9519\u8bef" + ex.getMessage());
                }
            };
            this.webSocketClient.connect();
            return this.webSocketClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

