package com.iplatform.tcp;

/**
 * TCP通信引擎类型定义。
 * @author 时克英
 * @date 2023-04-17
 */
public enum EngineType {

    TcpEngine{
        public int getIndex(){
            return INDEX_TCP_ENGINE;
        }
    },
    WebsocketEngine{
        public int getIndex(){
            return INDEX_TCP_WEBSOCKET;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public EngineType getType(int index){
        if(index == INDEX_TCP_ENGINE){
            return TcpEngine;
        } else if(index == INDEX_TCP_WEBSOCKET){
            return WebsocketEngine;
        } else {
            throw new UnsupportedOperationException("不支持的通信引擎:" + index);
        }
    }

    public static final int INDEX_TCP_ENGINE = 1;
    public static final int INDEX_TCP_WEBSOCKET = 2;
}
