package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquipStatus;
import com.iplatform.tcp.Constants;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalEquipStatusCacheProvider extends AbstractCacheProvider<TcpEquipStatus> implements EquipmentStatusCacheProvider {

    @Override
    public void putEquipmentStatus(String key, TcpEquipStatus tcpEquipStatus) {
        this.putCacheData(key, tcpEquipStatus);
    }

    @Override
    public TcpEquipStatus getEquipmentStatus(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void removeEquipmentStatus(String key) {
        this.removeCacheData(key);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<TcpEquipStatus> hosts = this.tcpEquipStatusService.selectAll(new TcpEquipStatus());
        if(!StringUtils.isEmptyList(hosts)){
            for(TcpEquipStatus h : hosts){
                cache.put(h.getEquipNum(), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_EQUIPMENT_STATUS;
    }

    @Override
    public Class<?> getProviderType() {
        return TcpEquipStatus.class;
    }

    public void setTcpEquipStatusService(TcpEquipStatusServiceImpl tcpEquipStatusService) {
        this.tcpEquipStatusService = tcpEquipStatusService;
    }

    private TcpEquipStatusServiceImpl tcpEquipStatusService;
}
