package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquip;
import com.iplatform.tcp.Constants;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class LocalEquipmentCacheProvider extends AbstractCacheProvider<TcpEquip> implements EquipmentCacheProvider {

    @Override
    protected int loadDataToCache(Cache cache) {
        List<TcpEquip> hosts = this.tcpEquipService.selectAll(new TcpEquip());
        if(!StringUtils.isEmptyList(hosts)){
            for(TcpEquip h : hosts){
                cache.put(h.getNum(), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_EQUIPMENT;
    }

    @Override
    public Class<?> getProviderType() {
        return TcpEquip.class;
    }

    public void setTcpEquipService(TcpEquipServiceImpl tcpEquipService) {
        this.tcpEquipService = tcpEquipService;
    }

    private TcpEquipServiceImpl tcpEquipService;

    @Override
    public void putEquipment(String key, TcpEquip tcpEquip) {
        this.putCacheData(key, tcpEquip);
    }

    @Override
    public TcpEquip getEquipment(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void removeEquipment(String key) {
        this.removeCacheData(key);
    }
}
