package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquipStatus;
import com.iplatform.tcp.Constants;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.List;

public class RedisEquipStatusCacheProvider extends RedisCacheProvider<TcpEquipStatus> implements EquipmentStatusCacheProvider {

    public RedisEquipStatusCacheProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putEquipmentStatus(String key, TcpEquipStatus tcpEquipStatus) {
        this.putCacheData(key, tcpEquipStatus);
    }

    @Override
    public TcpEquipStatus getEquipmentStatus(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void removeEquipmentStatus(String key) {
        this.removeCacheData(key);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_EQUIPMENT_STATUS;
    }

    @Override
    public Class<?> getProviderType() {
        return TcpEquipStatus.class;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<TcpEquipStatus> hosts = this.tcpEquipStatusService.selectAll(new TcpEquipStatus());
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(TcpEquipStatus h : hosts){
                        cache.put(h.getEquipNum(), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    public void setTcpEquipStatusService(TcpEquipStatusServiceImpl tcpEquipStatusService) {
        this.tcpEquipStatusService = tcpEquipStatusService;
    }

    private TcpEquipStatusServiceImpl tcpEquipStatusService;
}
