package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquip;
import com.iplatform.tcp.Constants;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.List;

public class RedisEquipmentCacheProvider extends RedisCacheProvider<TcpEquip> implements EquipmentCacheProvider {

    public RedisEquipmentCacheProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putEquipment(String key, TcpEquip tcpEquip) {
        this.putCacheData(key, tcpEquip);
    }

    @Override
    public TcpEquip getEquipment(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void removeEquipment(String key) {
        this.removeCacheData(key);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_EQUIPMENT;
    }

    @Override
    public Class<?> getProviderType() {
        return TcpEquip.class;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<TcpEquip> hosts = this.tcpEquipService.selectAll(new TcpEquip());
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(TcpEquip h : hosts){
                        cache.put(h.getNum(), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    public void setTcpEquipService(TcpEquipServiceImpl tcpEquipService) {
        this.tcpEquipService = tcpEquipService;
    }

    private TcpEquipServiceImpl tcpEquipService;
}
