package com.iplatform.tcp.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.tcp.lb.DefaultMqListener;
import com.iplatform.tcp.lb.DefaultResponseWriter;
import com.iplatform.tcp.lb.SimpleMqListener;
import com.walker.push.rocketmq.RocketMQEnhanceTemplate;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.lb.ResponseWriter;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 长连接负载方式时，启用MQ模板以及相关配置。
 * @author 时克英
 * @date 2023-09-26
 */
@Configuration
@ConditionalOnProperty(prefix = "iplatform.tcp", name = "load-balance-enabled", havingValue = "true", matchIfMissing = false)
@ConditionalOnClass({RocketMQTemplate.class})
public class LoadBalanceMQConfig extends PlatformConfiguration {

    private RocketMQTemplate rocketMQTemplate;

    @Autowired
    public LoadBalanceMQConfig(RocketMQTemplate rocketMQTemplate){
        this.rocketMQTemplate = rocketMQTemplate;
    }

    /**
     * 默认RocketMQ监听器配置，测试使用。正式需要删除
     * @param connectionManager
//     * @param template
     * @return
     * @date 2023-09-27
     */
//    @Bean
//    public DefaultMqListener defaultMqListener(ConnectionManager connectionManager, RocketMQEnhanceTemplate template){
//        DefaultMqListener listener = new DefaultMqListener();
//        listener.setConnectionManager(connectionManager);
//        listener.setRocketMQEnhanceTemplate(template);
//        return listener;
//    }
    @Bean
    public SimpleMqListener simpleMqListener(ConnectionManager connectionManager){
        SimpleMqListener listener = new SimpleMqListener();
        listener.setConnectionManager(connectionManager);
        return listener;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 以下为正式配置，上面为测试内容。
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 长连接响应消息写入通道具体实现。
     * <p>目前在负载模式中，发送消息到MQ，因为<code>LongConnectionMeta</code>从Redis反序列化后，无法执行子类write，所以通过该对象完成写入。</p>
     * @return
     * @date 2023-09-27
     */
    @Bean
    public ResponseWriter responseWriter(){
        return new DefaultResponseWriter();
    }

    @Bean
    public RocketMQEnhanceTemplate rocketMQEnhanceTemplate(){
        RocketMQEnhanceTemplate template = new RocketMQEnhanceTemplate();
        template.setTemplate(this.rocketMQTemplate);
//        template.setEnabledIsolation();
//        template.setEnvironmentName();
        return template;
    }
}
