package com.iplatform.tcp.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.cache.LocalEquipStatusCacheProvider;
import com.iplatform.tcp.cache.LocalEquipmentCacheProvider;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix = "iplatform.cache", name = "redis-enabled", havingValue = "false", matchIfMissing = true)
public class LocalTcpCacheConfig extends PlatformConfiguration {

    /**
     * 配置TCP设备信息缓存
     * @param tcpEquipService
     * @return
     * @date 2023-04-16
     */
    @Bean
    public EquipmentCacheProvider equipmentCacheProvider(TcpEquipServiceImpl tcpEquipService){
        LocalEquipmentCacheProvider localEquipmentCacheProvider = new LocalEquipmentCacheProvider();
        localEquipmentCacheProvider.setTcpEquipService(tcpEquipService);
        return localEquipmentCacheProvider;
    }

    /**
     * 配置设备状态缓存，一个设备一条记录。
     * @param tcpEquipStatusService
     * @return
     * @date 2023-04-16
     */
    @Bean
    public EquipmentStatusCacheProvider equipmentStatusCacheProvider(TcpEquipStatusServiceImpl tcpEquipStatusService){
        LocalEquipStatusCacheProvider localEquipStatusCacheProvider = new LocalEquipStatusCacheProvider();
        localEquipStatusCacheProvider.setTcpEquipStatusService(tcpEquipStatusService);
        return localEquipStatusCacheProvider;
    }
}
