package com.iplatform.tcp.controller;

import com.iplatform.tcp.TcpBaseController;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/tcp/connection")
public class ConnectionManagerController extends TcpBaseController {

    private ConnectionManager connectionManager;

    @Autowired
    public ConnectionManagerController(ConnectionManager connectionManager){
        this.connectionManager = connectionManager;
    }

    @RequestMapping("/list")
    public ResponseValue list(){
        List<Connection> list = this.connectionManager.queryAllConnectionList();
        if(list != null && list.size() > 256){
            logger.warn("TCP连接过多，仅展示前256个");
        }
        ListPageContext.setCurrentPageSize(256);
        GenericPager<Connection> pager = ListPageContext.createGenericPager(list, 1, list.size());
        return ResponseValue.success(pager);
    }

    @RequestMapping("/select/send_test")
    public ResponseValue sendTestCommand(){

        return ResponseValue.success();
    }
}
