package com.iplatform.tcp.controller;

import com.iplatform.base.SystemController;
import com.iplatform.tcp.util.ws.WebBroadCastResponse;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushManager;
import com.walker.push.PushResult;
import com.walker.tcp.netty.WebSocketEngine;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/test/tcp")
public class TestTcpController extends SystemController {

    private WebSocketEngine webSocketEngine;
    private PushManager pushManager;

    @Autowired
    public TestTcpController(WebSocketEngine webSocketEngine, PushManager pushManager){
        this.webSocketEngine = webSocketEngine;
        this.pushManager = pushManager;
    }

    @RequestMapping("/ws/send")
    public ResponseValue sendTestCommand(String name, String uid){
        WebBroadCastResponse msg = new WebBroadCastResponse();
        msg.setMessageId(String.valueOf(NumberGenerator.getSequenceNumber()));
        msg.setName(uid);
        msg.setData(name + ": " + msg.getMessageId());
        webSocketEngine.sendBroadcast(msg);
        return ResponseValue.success();
    }

    @RequestMapping("/push")
    public ResponseValue pushOne(String type, String userId){
        PushResult pushResult = null;
        if(type.equals("1")){
            logger.info("推送短信测试，user = 0");
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.Sms, "13838277463"), null);
        } else if(type.equals("2")){
            if(StringUtils.isEmpty(userId)){
                userId = "0";
            }
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.WebSocket, userId), null);
        } else {
            throw new UnsupportedOperationException("暂不支持其他推送方式：" + type);
        }
        return ResponseValue.success(pushResult);
    }

    private Notification acquireNotification(NotificationChannel channel, String user){
        Notification n = new Notification();
        n.setId(NumberGenerator.generatorHexUUID());
        n.setCreateTime(DateUtils.getDateTimeNumber());
        n.setCreator("creator");
        n.setFrom("shikeying");
        n.setContent("这是一个测试");

        List<NotificationChannel> channels = new ArrayList<>(2);
        channels.add(channel);
        n.setChannelList(channels);
        n.setPersistent(true);
        n.setTitle("title");

        List<String> userList = new ArrayList<>(2);
        userList.add(user);
        n.setReceiverList(userList);
        return n;
    }
}
