package com.iplatform.tcp.lb;

import com.walker.tcp.Connection;
import com.walker.tcp.lb.LoadBalanceConnectionManager;
import com.walker.tcp.lb.LongConnectionMeta;

/**
 * 支持集群的长连接管理器。
 * @author 时克英
 * @date 2023-09-26
 */
public class DefaultLbConnectionManager extends LoadBalanceConnectionManager {

//    private ResponseWriter responseWriter = new DefaultResponseWriter();

    @Override
    protected LongConnectionMeta acquireConnectionMeta(Connection connection) {
        MqConnectionMeta meta = new MqConnectionMeta(connection.getId());
        meta.setEngineId(connection.getEngineId());
        meta.setName(connection.getName());
        meta.setConnectionHost(connection.getConnectionHost());
        meta.setLastTime(connection.getLastTime());
        meta.setAlreadyLogin(connection.getAlreadyLogin());
        meta.setLongConnection(true);
//        meta.setProtocolResolver(connection.getProtocolResolver());
        meta.setResponseWriter(this.getResponseWriter());
        return meta;
    }

}
