package com.iplatform.tcp.util;

import com.walker.tcp.Request;
import com.walker.tcp.Response;
import com.walker.tcp.support.AbstractActionCall;

/**
 * 指令下发请求处理器，终端接到指令后，会发起确认请求，系统会调用该接口。</p>
 * 该处理器对应功能：立即定位指令
 * @author 时克英
 * @date 2018-08-22
 * @date 2023-04-17 移植过来，用于演示用法。
 */
//@Component
public class LocationNowAction extends AbstractActionCall {

	@Override
	public Response<?> action(Request<?> request) {
		logger.info("接收到指令下发后的，确认请求，不需要响应。请求信息 = " + request);
		// 可以再次更新业务状态，或者处理自己的商业过程
		return null;
	}

	@Override
	public String getRequestProtocol() {
		return "AP16";
	}
}
