package com.iplatform.tcp.util.ws;

import com.walker.tcp.Request;
import com.walker.tcp.Response;
import com.walker.tcp.support.AbstractActionCall;

/**
 * websocket登录认证请求处理器
 * @author 时克英
 * @date 2019-01-10
 *
 */
public class LoginAction extends AbstractActionCall {

	@Override
	public Response<?> action(Request<?> request) {
		logger.debug("接收到用户websocket登录请求：" + request.getName());
		LoginResponse response = new LoginResponse();
		response.setName(request.getName());
		response.setStatus(0);
		logger.debug(response.toString());
		return response;
	}

	@Override
	public String getRequestProtocol() {
		return "login";
	}
}
