/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquipStatus;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public class RedisEquipStatusCacheProvider
extends RedisCacheProvider<TcpEquipStatus>
implements EquipmentStatusCacheProvider {
    private TcpEquipStatusServiceImpl tcpEquipStatusService;

    public RedisEquipStatusCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putEquipmentStatus(String key, TcpEquipStatus tcpEquipStatus) {
        this.putCacheData(key, tcpEquipStatus);
    }

    @Override
    public TcpEquipStatus getEquipmentStatus(String key) {
        return (TcpEquipStatus)this.getCacheData(key);
    }

    @Override
    public void removeEquipmentStatus(String key) {
        this.removeCacheData(key);
    }

    public String getProviderName() {
        return "cache.tcp.equip_status";
    }

    public Class<?> getProviderType() {
        return TcpEquipStatus.class;
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.tcpEquipStatusService.selectAll((BasePo)new TcpEquipStatus());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (TcpEquipStatus h : hosts) {
                    cache.put(h.getEquipNum(), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    public void setTcpEquipStatusService(TcpEquipStatusServiceImpl tcpEquipStatusService) {
        this.tcpEquipStatusService = tcpEquipStatusService;
    }
}

