/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.cache.RedisEquipStatusCacheProvider;
import com.iplatform.tcp.cache.RedisEquipmentCacheProvider;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.tcp.lb.RedisConnectionMetaCache;
import com.walker.tcp.lb.RedisConnectionNameCache;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iplatform.cache", name={"redis-enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnClass(value={RedisCacheProvider.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisTcpCacheConfig
extends PlatformConfiguration {
    @Bean
    public RedisConnectionNameCache redisConnectionNameCache(RedisHelper redisHelper) {
        RedisConnectionNameCache cache = new RedisConnectionNameCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }

    @Bean
    public RedisConnectionMetaCache redisConnectionMetaCache(RedisHelper redisHelper) {
        RedisConnectionMetaCache cache = new RedisConnectionMetaCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }

    @Bean
    public EquipmentCacheProvider equipmentCacheProvider(RedisHelper redisHelper, TcpEquipServiceImpl tcpEquipService) {
        RedisEquipmentCacheProvider redisEquipmentCacheProvider = new RedisEquipmentCacheProvider();
        redisEquipmentCacheProvider.setRedisHelper(redisHelper);
        redisEquipmentCacheProvider.setTcpEquipService(tcpEquipService);
        return redisEquipmentCacheProvider;
    }

    @Bean
    public EquipmentStatusCacheProvider equipmentStatusCacheProvider(RedisHelper redisHelper, TcpEquipStatusServiceImpl tcpEquipStatusService) {
        RedisEquipStatusCacheProvider redisEquipStatusCacheProvider = new RedisEquipStatusCacheProvider();
        redisEquipStatusCacheProvider.setRedisHelper(redisHelper);
        redisEquipStatusCacheProvider.setTcpEquipStatusService(tcpEquipStatusService);
        return redisEquipStatusCacheProvider;
    }
}

