/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.config;

import com.iplatform.base.config.TcpProperties;
import com.iplatform.core.config.LoadBalanceProperties;
import com.iplatform.tcp.support.TestConnectionCallback;
import com.iplatform.tcp.support.WebSocketPush;
import com.iplatform.tcp.util.ws.LoginAction;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.push.PushManager;
import com.walker.push.Pushable;
import com.walker.queue.QueueManager;
import com.walker.tcp.ConnectionCallback;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.ServerHandler;
import com.walker.tcp.netty.DefaultLongHandler;
import com.walker.tcp.netty.DefaultServerInitializer;
import com.walker.tcp.netty.WebSocketEngine;
import com.walker.tcp.netty.WebSocketNettyHandler;
import com.walker.tcp.netty.WebSocketServerInitializer;
import com.walker.tcp.websocket.WebsocketHandler;
import com.walker.tcp.websocket.WebsocketProtocolResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
@ConditionalOnProperty(prefix="iplatform.tcp", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class WebsocketConfig {
    @Bean
    public WebsocketProtocolResolver websocketProtocolResolver() {
        WebsocketProtocolResolver websocketProtocolResolver = new WebsocketProtocolResolver();
        websocketProtocolResolver.setPermitNotRegisterConnect(false);
        return websocketProtocolResolver;
    }

    private List<ProtocolResolver<?>> acquireProtocolResolverList() {
        ArrayList protocolResolverList = new ArrayList(2);
        protocolResolverList.add((ProtocolResolver<?>)this.websocketProtocolResolver());
        return protocolResolverList;
    }

    @Bean
    public WebsocketHandler wsServerHandler(ConnectionManager connectionManager, QueueManager queueManager, TcpProperties tcpProperties) {
        WebsocketHandler websocketHandler = new WebsocketHandler();
        websocketHandler.setEmptyMsgDisconnect(false);
        websocketHandler.setEngineId(2);
        websocketHandler.setConnectionManager(connectionManager);
        websocketHandler.setQueueManager(queueManager);
        websocketHandler.setProtocolResolverList(this.acquireProtocolResolverList());
        websocketHandler.setScanPackages(tcpProperties.getScanPackagesWs());
        websocketHandler.setConnectionHost(tcpProperties.getConnectionHost());
        return websocketHandler;
    }

    @Bean
    public WebSocketNettyHandler wsNettyLongHandler(ConnectionManager connectionManager, WebsocketHandler wsServerHandler, TcpProperties tcpProperties) {
        WebSocketNettyHandler webSocketNettyHandler = new WebSocketNettyHandler();
        webSocketNettyHandler.setConnectionManager(connectionManager);
        webSocketNettyHandler.setTcpServerHandler((ServerHandler)wsServerHandler);
        webSocketNettyHandler.setUri(tcpProperties.getWebsocketUri());
        return webSocketNettyHandler;
    }

    @Bean
    public WebSocketServerInitializer wsServerInitializer(WebSocketNettyHandler wsNettyLongHandler, TcpProperties tcpProperties) {
        WebSocketServerInitializer webSocketServerInitializer = new WebSocketServerInitializer();
        webSocketServerInitializer.setHandler((DefaultLongHandler)wsNettyLongHandler);
        webSocketServerInitializer.setProtocolResolverList(this.acquireProtocolResolverList());
        webSocketServerInitializer.setShowLog(tcpProperties.isShowLog());
        return webSocketServerInitializer;
    }

    @Bean
    public WebSocketEngine webSocketEngine(ConnectionManager connectionManager, WebSocketServerInitializer webSocketServerInitializer, TcpProperties tcpProperties, @Nullable ConnectionCallback connectionCallback, LoadBalanceProperties loadBalanceProperties) {
        WebSocketEngine webSocketEngine = new WebSocketEngine();
        webSocketEngine.setId(2);
        webSocketEngine.setName("websocket\u6d4b\u8bd5\u5f15\u64ce");
        webSocketEngine.setConnectionManager(connectionManager);
        webSocketEngine.setServerInitializer((DefaultServerInitializer)webSocketServerInitializer);
        webSocketEngine.setOpenHeartBeat(tcpProperties.isOpenHeartBeat());
        webSocketEngine.setBossThreadNum(tcpProperties.getBossThreadNum());
        webSocketEngine.setWorkerThreadNum(tcpProperties.getWorkerThreadNum());
        webSocketEngine.setHeartBeatTimeInterval(tcpProperties.getHeartBeatSeconds() * 1000L);
        webSocketEngine.setPort(tcpProperties.getPortWs());
        if (connectionCallback != null) {
            webSocketEngine.setConnectionCallback(connectionCallback);
        } else {
            webSocketEngine.setConnectionCallback((ConnectionCallback)new TestConnectionCallback());
        }
        webSocketEngine.setEngineStartDelaySeconds(30L);
        try {
            webSocketEngine.start();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("\u542f\u52a8'WebSocketEngine'\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return webSocketEngine;
    }

    @Bean
    public LoginAction wsLoginAction() {
        LoginAction loginAction = new LoginAction();
        return loginAction;
    }

    @Bean
    public Pushable websocketPush(WebSocketEngine webSocketEngine, PushManager pushManager) {
        WebSocketPush webSocketPush = new WebSocketPush();
        webSocketPush.setWebSocketEngine(webSocketEngine);
        webSocketPush.startup();
        pushManager.register((Pushable)webSocketPush);
        return webSocketPush;
    }
}

