/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.controller;

import com.iplatform.base.SystemController;
import com.iplatform.tcp.util.ws.WebBroadCastResponse;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushManager;
import com.walker.push.PushResult;
import com.walker.tcp.Response;
import com.walker.tcp.netty.WebSocketEngine;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test/tcp"})
public class TestTcpController
extends SystemController {
    private WebSocketEngine webSocketEngine;
    private PushManager pushManager;

    @Autowired
    public TestTcpController(WebSocketEngine webSocketEngine, PushManager pushManager) {
        this.webSocketEngine = webSocketEngine;
        this.pushManager = pushManager;
    }

    @RequestMapping(value={"/ws/send"})
    public ResponseValue sendTestCommand(String name, String uid) {
        WebBroadCastResponse msg = new WebBroadCastResponse();
        msg.setMessageId(String.valueOf(NumberGenerator.getSequenceNumber()));
        msg.setName(uid);
        msg.setData(name + ": " + msg.getMessageId());
        this.webSocketEngine.sendBroadcast((Response)msg);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/push"})
    public ResponseValue pushOne(String type, String userId) {
        PushResult pushResult = null;
        if (type.equals("1")) {
            this.logger.info("\u63a8\u9001\u77ed\u4fe1\u6d4b\u8bd5\uff0cuser = 0");
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.Sms, "13838277463"), null);
        } else if (type.equals("2")) {
            if (StringUtils.isEmpty((String)userId)) {
                userId = "0";
            }
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.WebSocket, userId), null);
        } else {
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u63a8\u9001\u65b9\u5f0f\uff1a" + type);
        }
        return ResponseValue.success((Object)pushResult);
    }

    private Notification acquireNotification(NotificationChannel channel, String user) {
        Notification n = new Notification();
        n.setId(NumberGenerator.generatorHexUUID());
        n.setCreateTime(DateUtils.getDateTimeNumber());
        n.setCreator("creator");
        n.setFrom("shikeying");
        n.setContent("\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5");
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(channel);
        n.setChannelList(channels);
        n.setPersistent(true);
        n.setTitle("title");
        ArrayList<String> userList = new ArrayList<String>(2);
        userList.add(user);
        n.setReceiverList(userList);
        return n;
    }
}

