/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.support;

import com.iplatform.model.po.TcpEquip;
import com.iplatform.model.po.TcpEquipStatus;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.jdbc.BasePo;
import com.walker.tcp.Connection;
import com.walker.tcp.support.SimpleEngineConnectionManager;

public class PersistentConnectionManager
extends SimpleEngineConnectionManager {
    private boolean websocketPersistent = false;
    private EquipmentStatusCacheProvider statusCache;
    private EquipmentCacheProvider equipCache;
    private TcpEquipStatusServiceImpl tcpEquipStatusService;

    public void setWebsocketPersistent(boolean websocketPersistent) {
        this.websocketPersistent = websocketPersistent;
    }

    protected void onSaveConnection(Connection connection) throws Exception {
        if (connection.getEngineId() == 2 && !this.websocketPersistent) {
            return;
        }
        this.logger.debug("\u4fdd\u5b58\u4e86\u4e00\u4e2a\u8fde\u63a5\uff1a" + connection.getName());
        String num = connection.getName();
        TcpEquipStatus cacheStatus = this.statusCache.getEquipmentStatus(num);
        if (cacheStatus == null) {
            TcpEquipStatus newStatus = this.createStatus(connection, num);
            this.tcpEquipStatusService.insert((BasePo)newStatus);
            this.statusCache.putEquipmentStatus(num, newStatus);
        } else {
            cacheStatus.setStartTime(Long.valueOf(Long.parseLong(DateUtils.getDateTimeSecondForShow((long)System.currentTimeMillis()))));
            cacheStatus.setLiveStatus(Integer.valueOf(1));
            this.tcpEquipStatusService.save((BasePo)cacheStatus);
        }
        this.afterSaveConnection(cacheStatus);
    }

    private TcpEquipStatus createStatus(Connection connection, String num) {
        TcpEquip equip = this.getEquipmentFromCache(num);
        TcpEquipStatus entity = new TcpEquipStatus();
        entity.setCreateTime(Long.valueOf(NumberGenerator.getSequenceNumber()));
        entity.setEquipNum(num);
        entity.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        entity.setLiveStatus(Integer.valueOf(1));
        entity.setStartTime(Long.valueOf(Long.parseLong(DateUtils.getDateTimeSecondForShow((long)connection.getCreateTimeMills()))));
        if (equip == null) {
            entity.setEquipId(Long.valueOf(0L));
            entity.setDept(Long.valueOf(0L));
        } else {
            entity.setEquipId(equip.getId());
            entity.setDept(equip.getDept());
        }
        return entity;
    }

    private TcpEquip getEquipmentFromCache(String num) {
        return this.equipCache.getEquipment(num);
    }

    protected void onDeleteConnection(int engineId, String name) throws Exception {
        if (engineId == 2 && !this.websocketPersistent) {
            return;
        }
        this.logger.debug("\u5220\u9664\u4e86\u4e00\u4e2a\u8fde\u63a5\uff1a" + name);
        TcpEquipStatus cacheStatus = this.statusCache.getEquipmentStatus(name);
        cacheStatus.setEndTime(Long.valueOf(Long.parseLong(DateUtils.getDateTimeSecondForShow((long)System.currentTimeMillis()))));
        cacheStatus.setLiveStatus(Integer.valueOf(0));
        this.tcpEquipStatusService.save((BasePo)cacheStatus);
        this.afterDeleteConnection(cacheStatus);
    }

    protected void onUpdateLastTime(int engineId, String name, long lastTime) throws Exception {
        this.logger.debug("\u66f4\u65b0\u4e86\u4e00\u4e2a\u8fde\u63a5\uff1a" + name);
    }

    protected void afterSaveConnection(TcpEquipStatus cacheStatus) {
    }

    protected void afterDeleteConnection(TcpEquipStatus cacheStatus) {
    }

    public void setStatusCache(EquipmentStatusCacheProvider statusCache) {
        this.statusCache = statusCache;
    }

    public void setEquipCache(EquipmentCacheProvider equipCache) {
        this.equipCache = equipCache;
    }

    public void setTcpEquipStatusService(TcpEquipStatusServiceImpl tcpEquipStatusService) {
        this.tcpEquipStatusService = tcpEquipStatusService;
    }
}

