package com.iplatform.tcp;

/**
 * 通讯连接状态枚举类型定义
 * @author 时克英
 * @date 2018-11-29
 *
 */
public enum LiveStatus {

	/**
	 * 未连接：0
	 */
	NotConnect {
		public int getTypeValue(){
			return CONST_NOT_CONNECT;
		}
	},

	/**
	 * 已连接：1
	 */
	Connected {
		public int getTypeValue(){
			return CONST_CONNECTED;
		}
	};

	public static final int CONST_CONNECTED = 1;
	public static final int CONST_NOT_CONNECT = 0;

	public int getTypeValue(){
		throw new AbstractMethodError();
	}

	public static LiveStatus getType(int index){
		if(index == CONST_CONNECTED){
			return Connected;
		} else if(index == CONST_NOT_CONNECT){
			return NotConnect;
		} else
			throw new IllegalArgumentException("unsupported LiveStatus: " + index);
	}
}
