package com.iplatform.tcp.controller;

import com.iplatform.model.po.TcpEquip;
import com.iplatform.tcp.TcpBaseController;
import com.iplatform.tcp.pojo.EquipParam;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.ProtocolResolverPostProcessor;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/tcp/equip")
public class EquipController extends TcpBaseController {

    private TcpEquipServiceImpl tcpEquipService;
//    private ProtocolResolverPostProcessor protocolResolverPostProcessor;

    @Autowired
    public EquipController(TcpEquipServiceImpl tcpEquipService){
        this.tcpEquipService = tcpEquipService;
    }

    @RequestMapping("/list")
    public ResponseValue list(EquipParam equipParam){
//        PageSearch pageSearch = ListPageContext.getPageSearch();
//        GenericPager<TcpEquip> pager = this.tcpEquipService.selectSplit(new TcpEquip(), pageSearch.getPageIndex(), pageSearch.getPageSize());
        GenericPager<TcpEquip> pager = this.tcpEquipService.selectSplit(new TcpEquip());
        List<TcpEquip> data = pager.getDatas();
        if(!StringUtils.isEmptyList(data)){
            for(TcpEquip e : data){
                e.setParameterString("deptName", this.getDeptName(e.getDept()));
                e.setParameterString("protocolResolverName", ProtocolResolverPostProcessor.getProtocolResolver(e.getProtocolResolver()).getName());
            }
        }
        return ResponseValue.success(pager);
    }
}
