package com.iplatform.tcp.support;

import com.iplatform.tcp.util.ws.WebBroadCastResponse;
import com.iplatform.tcp.util.ws.WebDataResponse;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;
import com.walker.tcp.netty.WebSocketEngine;

import java.util.ArrayList;
import java.util.List;

/**
 * WebSocket方式实现的推送对象。
 * @author 时克英
 * @date 2023-04-21
 */
public class WebSocketPush extends AbstractPushObject<WebBroadCastResponse> {

    public WebSocketPush(){
        this.setId(NotificationChannel.WebSocket.getIndex());
        this.setName(NotificationChannel.WebSocket.getName() + "推送");
    }

    @Override
    protected PushResult doPushContent(Notification notification, List<WebBroadCastResponse> data) throws PushException {
        PushResult pushResult = PushUtils.acquireSuccessPushResult();
        String error = null;
        for(WebBroadCastResponse response : data){
            if(notification.getBroadcast()){
                webSocketEngine.sendBroadcast(response);
                logger.debug("websocket广播直接发送，没有状态");
                return pushResult;
            }

            error = this.webSocketEngine.sendResponse(response);

            if(StringUtils.isNotEmpty(error)){
                if(pushResult.getCode() == 0){
                    pushResult.setCode(-1);
                }
                // 这里无需转换用户信息，因为使用的就是userId，一致的!
                pushResult.addOneFailed(response.getName());
            }
        }
        return pushResult;
    }

//    @Override
//    protected PushResult doPushContent(Notification notification) throws PushException {
//        if(notification.getBroadcast()){
//            logger.debug("websocket推送广播");
//
//            WebBroadCastResponse msg = new WebBroadCastResponse();
//            msg.setMessageId(String.valueOf(NumberGenerator.getSequenceNumber()));
//            msg.setData(notification.getContent());
//            webSocketEngine.sendBroadcast(msg);
//            return PushUtils.acquireSuccessPushResult();
//        }
//
//        // 普通推送消息
//        PushResult pushResult = new PushResult();
//        WebDataResponse response = null;
//        String error = null;
//
//        List<String> receiverList = notification.getReceiverList();
//        for(String user : receiverList){
//            response = new WebDataResponse();
//            response.setMessageId(String.valueOf(NumberGenerator.getSequenceNumber()));
//            response.setData(notification.getContent());
//            response.setName(user); // websocket用户标识为：userId
//            error = this.webSocketEngine.sendResponse(response);
//
//            if(StringUtils.isNotEmpty(error)){
//                if(pushResult.getCode() == 0){
//                    pushResult.setCode(-1);
//                }
//                pushResult.addOneFailed(user);
//            }
//        }
//        return pushResult;
//    }

    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.WebSocket;
    }

    @Override
    public List<WebBroadCastResponse> translateToTarget(Notification notification) {

        List<WebBroadCastResponse> data = new ArrayList<>(2);
        WebBroadCastResponse webBroadCastResponse = null;

        if(notification.getBroadcast()){
            logger.debug("websocket推送广播");
            webBroadCastResponse = new WebBroadCastResponse();
            webBroadCastResponse.setMessageId(notification.getId());
            webBroadCastResponse.setData(notification.getContent());
            data.add(webBroadCastResponse);
            return data;
        }

        // 非广播，则需要把所有接收人集合返回
        int i = 1;
        for(String user: notification.getReceiverList()){
            webBroadCastResponse = new WebDataResponse();
            webBroadCastResponse.setMessageId(notification.getId() + i);
            webBroadCastResponse.setData(notification.getContent());
            webBroadCastResponse.setName(user); // websocket用户标识为：userId
            data.add(webBroadCastResponse);
            i++;
        }
        return data;
    }

    @Override
    public void startup() {

    }

    public void setWebSocketEngine(WebSocketEngine webSocketEngine) {
        this.webSocketEngine = webSocketEngine;
    }

    private WebSocketEngine webSocketEngine;
}
