package com.iplatform.tcp.util.ws;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.tcp.TcpRequest;
import com.walker.tcp.data.AbstractStringRequest;
import com.walker.tcp.util.WebSocketUtils;

@TcpRequest("login")
public class LoginRequest extends AbstractStringRequest {

	/**
	 *
	 */
	private static final long serialVersionUID = 8346500913809847710L;

	@Override
	protected void translateData(String source) {
//		JSONObject json = JSONObject.parseObject(source);
//		this.setName(json.getString(WebSocketUtils.WEB_SOCKET_KEY_UID));
		ObjectNode json = null;
		try {
			json = JsonUtils.jsonStringToObjectNode(source);
			this.setName(json.get(WebSocketUtils.WEB_SOCKET_KEY_UID).asText());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public String getProtocolNum() {
		return "login";
	}
}
