/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquipStatus;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.List;

public class LocalEquipStatusCacheProvider
extends AbstractCacheProvider<TcpEquipStatus>
implements EquipmentStatusCacheProvider {
    private TcpEquipStatusServiceImpl tcpEquipStatusService;

    @Override
    public void putEquipmentStatus(String key, TcpEquipStatus tcpEquipStatus) {
        this.putCacheData(key, tcpEquipStatus);
    }

    @Override
    public TcpEquipStatus getEquipmentStatus(String key) {
        return (TcpEquipStatus)this.getCacheData(key);
    }

    @Override
    public void removeEquipmentStatus(String key) {
        this.removeCacheData(key);
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.tcpEquipStatusService.selectAll((BasePo)new TcpEquipStatus());
        if (!StringUtils.isEmptyList((List)hosts)) {
            for (TcpEquipStatus h : hosts) {
                cache.put(h.getEquipNum(), (Object)h);
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.tcp.equip_status";
    }

    public Class<?> getProviderType() {
        return TcpEquipStatus.class;
    }

    public void setTcpEquipStatusService(TcpEquipStatusServiceImpl tcpEquipStatusService) {
        this.tcpEquipStatusService = tcpEquipStatusService;
    }
}

