/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.cache;

import com.iplatform.model.po.TcpEquip;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.service.TcpEquipServiceImpl;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public class RedisEquipmentCacheProvider
extends RedisCacheProvider<TcpEquip>
implements EquipmentCacheProvider {
    private TcpEquipServiceImpl tcpEquipService;

    public RedisEquipmentCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void putEquipment(String key, TcpEquip tcpEquip) {
        this.putCacheData(key, tcpEquip);
    }

    @Override
    public TcpEquip getEquipment(String key) {
        return (TcpEquip)this.getCacheData(key);
    }

    @Override
    public void removeEquipment(String key) {
        this.removeCacheData(key);
    }

    public String getProviderName() {
        return "cache.tcp.equip";
    }

    public Class<?> getProviderType() {
        return TcpEquip.class;
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.tcpEquipService.selectAll((BasePo)new TcpEquip());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (TcpEquip h : hosts) {
                    cache.put(h.getNum(), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    public void setTcpEquipService(TcpEquipServiceImpl tcpEquipService) {
        this.tcpEquipService = tcpEquipService;
    }
}

