/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.config;

import com.iplatform.core.PlatformConfiguration;
import com.iplatform.tcp.lb.DefaultResponseWriter;
import com.walker.push.rocketmq.RocketMQEnhanceTemplate;
import com.walker.tcp.lb.ResponseWriter;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iplatform.tcp", name={"load-balance-enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnClass(value={RocketMQTemplate.class})
public class LoadBalanceMQConfig
extends PlatformConfiguration {
    private RocketMQTemplate rocketMQTemplate;

    @Autowired
    public LoadBalanceMQConfig(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }

    @Bean
    public ResponseWriter responseWriter() {
        return new DefaultResponseWriter();
    }

    @Bean
    public RocketMQEnhanceTemplate rocketMQEnhanceTemplate() {
        RocketMQEnhanceTemplate template = new RocketMQEnhanceTemplate();
        template.setTemplate(this.rocketMQTemplate);
        return template;
    }
}

