/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.config;

import com.iplatform.base.config.TcpProperties;
import com.iplatform.core.PlatformConfiguration;
import com.iplatform.core.config.LoadBalanceProperties;
import com.iplatform.tcp.EquipmentCacheProvider;
import com.iplatform.tcp.EquipmentStatusCacheProvider;
import com.iplatform.tcp.lb.DefaultLbConnectionManager;
import com.iplatform.tcp.service.TcpEquipStatusServiceImpl;
import com.iplatform.tcp.support.PersistentConnectionManager;
import com.iplatform.tcp.support.PlatformSharpProtocolResolver;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.push.rocketmq.RocketQueueManager;
import com.walker.queue.QueueManager;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.ServerHandler;
import com.walker.tcp.handler.LongHandler;
import com.walker.tcp.lb.RedisConnectionMetaCache;
import com.walker.tcp.lb.RedisConnectionNameCache;
import com.walker.tcp.lb.ResponseWriter;
import com.walker.tcp.netty.DefaultLongEngine;
import com.walker.tcp.netty.DefaultLongHandler;
import com.walker.tcp.netty.DefaultServerInitializer;
import com.walker.tcp.protocol.LineProtocolResolver;
import com.walker.tcp.support.MemoryQueueManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnProperty(prefix="iplatform.tcp", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class TcpConfig
extends PlatformConfiguration {
    @ConditionalOnProperty(prefix="iplatform.tcp", name={"custom-connection-manager"}, havingValue="false", matchIfMissing=false)
    @Bean
    public ConnectionManager connectionManager(EquipmentCacheProvider equipmentCacheProvider, EquipmentStatusCacheProvider equipmentStatusCacheProvider, TcpEquipStatusServiceImpl tcpEquipStatusService, TcpProperties tcpProperties, @Nullable RedisConnectionMetaCache connectionMetaCache, @Nullable RedisConnectionNameCache connectionNameCache, @Nullable ResponseWriter responseWriter) {
        HashMap<Integer, String> connectionTypeMap = new HashMap<Integer, String>(4);
        connectionTypeMap.put(1, "TCP\u957f\u8fde\u63a5");
        connectionTypeMap.put(2, "WebSocket\u8fde\u63a5");
        if (tcpProperties.isLoadBalanceEnabled()) {
            DefaultLbConnectionManager connectionManager = new DefaultLbConnectionManager();
            connectionManager.setMultipleEngine(true);
            connectionManager.setConnectionTypeMap(connectionTypeMap);
            connectionManager.setConnectionMetaCache(connectionMetaCache);
            connectionManager.setConnectionNameCache(connectionNameCache);
            connectionManager.setConnectionHost(tcpProperties.getConnectionHost());
            connectionManager.setResponseWriter(responseWriter);
            this.logger.debug("getConnectionHost = {}", (Object)tcpProperties.getConnectionHost());
            this.logger.info("connectionMetaCache = {}", (Object)connectionMetaCache.getClass().getName());
            return connectionManager;
        }
        PersistentConnectionManager connectionManager = new PersistentConnectionManager();
        connectionManager.setMultipleEngine(true);
        connectionManager.setConnectionTypeMap(connectionTypeMap);
        connectionManager.setEquipCache(equipmentCacheProvider);
        connectionManager.setStatusCache(equipmentStatusCacheProvider);
        connectionManager.setTcpEquipStatusService(tcpEquipStatusService);
        return connectionManager;
    }

    @Bean
    public LineProtocolResolver lineProtocolResolver() {
        return new LineProtocolResolver();
    }

    @Bean
    public PlatformSharpProtocolResolver platformSharpProtocolResolver() {
        PlatformSharpProtocolResolver resolver = new PlatformSharpProtocolResolver();
        return resolver;
    }

    @Bean
    public QueueManager queueManager(ConnectionManager connectionManager, TcpProperties tcpProperties, ThreadPoolTaskExecutor executor) {
        if (tcpProperties.isLoadBalanceEnabled()) {
            RocketQueueManager queueManager = new RocketQueueManager();
            queueManager.setConnectionManager(connectionManager);
            queueManager.setId(1);
            queueManager.setName("\u62a5\u6587\u6d88\u606f\u961f\u5217\u7ba1\u7406\u5668\u3010\u96c6\u7fa4\u3011");
            queueManager.setExecutor(executor);
            queueManager.startup();
            return queueManager;
        }
        MemoryQueueManager queueManager = new MemoryQueueManager();
        queueManager.setConnectionManager(connectionManager);
        queueManager.setId(1);
        queueManager.setName("\u62a5\u6587\u6d88\u606f\u961f\u5217\u7ba1\u7406\u5668\u3010\u5185\u7f6e\u3011");
        queueManager.setMaxWorkerThread(1);
        queueManager.startup();
        return queueManager;
    }

    private List<ProtocolResolver<?>> acquireProtocolResolverList() {
        ArrayList protocolResolverList = new ArrayList(4);
        protocolResolverList.add((ProtocolResolver<?>)this.lineProtocolResolver());
        protocolResolverList.add((ProtocolResolver<?>)this.platformSharpProtocolResolver());
        return protocolResolverList;
    }

    @Bean
    public LongHandler tcpServerHandler(QueueManager queueManager, ConnectionManager connectionManager, TcpProperties tcpProperties) {
        this.logger.debug("...... tcp_scan_packages = {}", (Object)tcpProperties.getScanPackagesTcp());
        LongHandler longHandler = new LongHandler();
        longHandler.setEmptyMsgDisconnect(false);
        longHandler.setEngineId(1);
        longHandler.setScanPackages(tcpProperties.getScanPackagesTcp());
        longHandler.setQueueManager(queueManager);
        longHandler.setConnectionManager(connectionManager);
        longHandler.setProtocolResolverList(this.acquireProtocolResolverList());
        longHandler.setConnectionHost(tcpProperties.getConnectionHost());
        return longHandler;
    }

    @Bean
    public DefaultLongHandler nettyLongHandler(ConnectionManager connectionManager, LongHandler tcpServerHandler) {
        DefaultLongHandler longHandler = new DefaultLongHandler();
        longHandler.setConnectionManager(connectionManager);
        longHandler.setTcpServerHandler((ServerHandler)tcpServerHandler);
        return longHandler;
    }

    @Bean
    public DefaultServerInitializer nettyServerInitializer(DefaultLongHandler nettyLongHandler, TcpProperties tcpProperties) {
        DefaultServerInitializer initializer = new DefaultServerInitializer();
        initializer.setHandler(nettyLongHandler);
        initializer.setProtocolResolverList(this.acquireProtocolResolverList());
        initializer.setShowLog(tcpProperties.isShowLog());
        return initializer;
    }

    @Bean
    public DefaultLongEngine tcpLongEngine(DefaultServerInitializer nettyServerInitializer, ConnectionManager connectionManager, TcpProperties tcpProperties, LoadBalanceProperties loadBalanceProperties) {
        DefaultLongEngine longEngine = new DefaultLongEngine();
        longEngine.setId(1);
        longEngine.setName("\u6d4b\u8bd5TCP\u957f\u8fde\u63a5\u5f15\u64ce");
        longEngine.setServerInitializer(nettyServerInitializer);
        longEngine.setConnectionManager(connectionManager);
        longEngine.setPort(tcpProperties.getPortTcp());
        longEngine.setBossThreadNum(tcpProperties.getBossThreadNum());
        longEngine.setWorkerThreadNum(tcpProperties.getWorkerThreadNum());
        longEngine.setOpenHeartBeat(tcpProperties.isOpenHeartBeat());
        try {
            longEngine.start();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("\u542f\u52a8'DefaultLongEngine'\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return longEngine;
    }
}

