/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.controller;

import com.iplatform.base.SystemController;
import com.iplatform.tcp.util.ws.WebBroadCastResponse;
import com.iplatform.tcp.util.ws.WebDataResponse;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushManager;
import com.walker.push.PushResult;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.Response;
import com.walker.tcp.connect.LongConnection;
import com.walker.tcp.lb.LongConnectionMeta;
import com.walker.tcp.lb.RedisConnectionMetaCache;
import com.walker.tcp.lb.RedisConnectionNameCache;
import com.walker.tcp.netty.WebSocketEngine;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test/tcp"})
public class TestTcpController
extends SystemController {
    private WebSocketEngine webSocketEngine;
    private PushManager pushManager;
    private RedisConnectionMetaCache connectionMetaCache;
    private RedisConnectionNameCache connectionNameCache;

    @Autowired
    public TestTcpController(WebSocketEngine webSocketEngine, PushManager pushManager, @Nullable RedisConnectionMetaCache connectionMetaCache, @Nullable RedisConnectionNameCache connectionNameCache) {
        this.webSocketEngine = webSocketEngine;
        this.pushManager = pushManager;
        this.connectionMetaCache = connectionMetaCache;
        this.connectionNameCache = connectionNameCache;
    }

    @RequestMapping(value={"/ws/info"})
    public ResponseValue getWebsocketLinkInfo() {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        if (this.connectionNameCache != null) {
            long totalWebsocketSize = this.connectionNameCache.getCache().getPersistentSize();
            infoMap.put("total_websocket", totalWebsocketSize);
            infoMap.put("create_time", this.connectionNameCache.getCreateTime());
            infoMap.put("cache_name", this.connectionNameCache.getProviderName());
        }
        if (this.connectionMetaCache != null) {
            infoMap.put("connection_meta_size", this.connectionMetaCache.getCache().getPersistentSize());
        }
        return ResponseValue.success(infoMap);
    }

    @RequestMapping(value={"/ws/connection"})
    public ResponseValue getWebsocketConnection(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return ResponseValue.error((String)"userId is required!");
        }
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        ConnectionManager connectionManager = this.webSocketEngine.getConnectionManager();
        if (connectionManager != null) {
            LongConnection connection = (LongConnection)connectionManager.getConnectionByName(userId);
            if (connection == null) {
                return ResponseValue.success((String)("\u8fde\u63a5\u4e0d\u5b58\u5728\uff1a" + userId));
            }
            if (connection instanceof LongConnectionMeta) {
                infoMap.put("type", "\u96c6\u7fa4\u8fde\u63a5\u5bf9\u8c61(LongConnectionMeta)\uff0c\u4e0d\u662f\u5f53\u524d\u4e3b\u673a\u7269\u7406\u8fde\u63a5");
            }
            infoMap.put("id", connection.getId());
            infoMap.put("host", connection.getConnectionHost());
            infoMap.put("name", connection.getName());
            infoMap.put("alreadyLogin", connection.getAlreadyLogin());
            infoMap.put("engineId", connection.getEngineId());
            infoMap.put("lastTime", connection.getLastTime());
        } else {
            infoMap.put("error", "connectionManager \u4e3a\u7a7a");
        }
        return ResponseValue.success(infoMap);
    }

    @RequestMapping(value={"/ws/send_broadcast"})
    public ResponseValue sendTestCommand(String name, String uid) {
        WebBroadCastResponse msg = new WebBroadCastResponse();
        msg.setMessageId(String.valueOf(NumberGenerator.getSequenceNumber()));
        msg.setName(uid);
        msg.setData(name + ": " + msg.getMessageId());
        this.webSocketEngine.sendBroadcast((Response)msg);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/ws/send"})
    public ResponseValue sendToUser(String userId) {
        Connection connection = this.webSocketEngine.getConnectionManager().getConnectionByName(userId);
        if (connection == null) {
            return ResponseValue.error((String)("\u8fde\u63a5\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u63a8\u9001\u6d4f\u89c8\u5668\u6d88\u606f\u7ed9\u7528\u6237\uff1a" + userId));
        }
        WebDataResponse msg = new WebDataResponse();
        msg.setMessageId(NumberGenerator.getLongSequenceId());
        msg.setName(userId);
        msg.setData("\u4f60\u597d\uff0c\u8fd9\u662f\u63a8\u9001\u7ed9\u6d4f\u89c8\u5668\u7684\u5185\u5bb9\u3002");
        this.webSocketEngine.sendResponse((Response)msg);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/push"})
    public ResponseValue pushOne(String type, String userId) {
        PushResult pushResult = null;
        if (type.equals("1")) {
            this.logger.info("\u63a8\u9001\u77ed\u4fe1\u6d4b\u8bd5\uff0cuser = 0");
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.Sms, "13838277463"), null);
        } else if (type.equals("2")) {
            if (StringUtils.isEmpty((String)userId)) {
                userId = "0";
            }
            pushResult = this.pushManager.push(this.acquireNotification(NotificationChannel.WebSocket, userId), null);
        } else {
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u63a8\u9001\u65b9\u5f0f\uff1a" + type);
        }
        return ResponseValue.success((Object)pushResult);
    }

    private Notification acquireNotification(NotificationChannel channel, String user) {
        Notification n = new Notification();
        n.setId(NumberGenerator.generatorHexUUID());
        n.setCreateTime(DateUtils.getDateTimeNumber());
        n.setCreator("creator");
        n.setFrom("shikeying");
        n.setContent("\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5");
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(channel);
        n.setChannelList(channels);
        n.setPersistent(true);
        n.setTitle("title");
        ArrayList<String> userList = new ArrayList<String>(2);
        userList.add(user);
        n.setReceiverList(userList);
        return n;
    }
}

