/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.lb;

import com.iplatform.tcp.util.ws.LoginResponse;
import com.iplatform.tcp.util.ws.WebDataResponse;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.push.rocketmq.EnhanceMessageHandler;
import com.walker.push.rocketmq.tcp.MqResponse;
import com.walker.queue.MqBaseMessage;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.Response;
import com.walker.tcp.lb.LongConnectionMeta;
import java.util.Map;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;

@RocketMQMessageListener(topic="${iplatform.tcp.connection-host}", consumerGroup="consumer-group")
public class DefaultMqListener
extends EnhanceMessageHandler<MqResponse>
implements RocketMQListener<MqResponse> {
    private final String KEY_PROTOCOL_NUM = "protocolNum";
    private ConnectionManager connectionManager;

    public void onMessage(MqResponse mqResponse) {
        this.dispatchMessage((MqBaseMessage)mqResponse);
    }

    protected void handleMessage(MqResponse message) throws Exception {
        Response<?> response = this.translateResponse(message.getResponse());
        Connection conn = this.connectionManager.getConnectionByName(response.getName());
        if (conn == null || !conn.isConnected()) {
            this.logger.debug("mq\u6d88\u606f\u5df2\u63a5\u6536\uff0c\u4f46\u957f\u8fde\u63a5\u4e0d\u5b58\u5728\u65e0\u6cd5\u63a8\u9001\uff0cresponse = {}", response);
            return;
        }
        if (conn instanceof LongConnectionMeta) {
            throw new IllegalStateException("\u8fd9\u4e2a\u5e94\u8be5\u662f\u672c\u5730\u7269\u7406\u8fde\u63a5\uff0c\u4f46\u627e\u5230\u7684\u662f\uff1aLongConnectionMeta\uff0cname=" + response.getName());
        }
        conn.write(response);
    }

    protected Response<?> translateResponse(String json) throws Exception {
        Map responseMap = (Map)JsonUtils.jsonStringToObject((String)json, Map.class);
        if (!responseMap.containsKey("protocolNum")) {
            throw new IllegalArgumentException("responseMap\u4e2d\u5fc5\u987b\u5305\u542b\u534f\u8bae\u53f7\u5b57\u6bb5:protocolNum");
        }
        String protocolNum = responseMap.get("protocolNum").toString();
        if (protocolNum.equals("login")) {
            return (Response)JsonUtils.jsonStringToObject((String)json, LoginResponse.class);
        }
        if (protocolNum.equals("data")) {
            return (Response)JsonUtils.jsonStringToObject((String)json, WebDataResponse.class);
        }
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u7684 websocket.response\u5bf9\u8c61\u8f6c\u6362\uff1a" + json);
    }

    protected void handleMaxRetriesExceeded(MqResponse message) {
    }

    protected boolean isRetry() {
        return false;
    }

    protected boolean throwException() {
        return true;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }
}

