/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.lb;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.core.BeanContextAware;
import com.iplatform.tcp.lb.SendStatusCallback;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.push.rocketmq.RocketMQEnhanceTemplate;
import com.walker.push.rocketmq.tcp.MqResponse;
import com.walker.queue.MqBaseMessage;
import com.walker.tcp.Response;
import com.walker.tcp.lb.ResponseWriter;
import com.walker.web.util.IdUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseWriter
implements ResponseWriter {
    private final transient SendStatusCallback callback = new SendStatusCallback();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object write(String type, Response<?> response, String connectionHost, String channelId) {
        if (type.equals("mq")) {
            this.logger.debug("+++++++++++++++++++++++++");
            ((RocketMQEnhanceTemplate)BeanContextAware.getBeanByType(RocketMQEnhanceTemplate.class)).sendAsync(connectionHost, (MqBaseMessage)this.acquireMqResponse(response), (SendCallback)this.callback);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MqConnectionMeta \u53d1\u9001\u4e00\u4e2a\u6d88\u606f\uff1a{}", response);
            }
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684 ResponseWriter.type = " + type);
        }
        return null;
    }

    private MqResponse acquireMqResponse(Response<?> response) {
        MqResponse data = new MqResponse();
        try {
            data.setResponse(JsonUtils.objectToJsonString(response));
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("Response<?> --> String \u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        data.setKey(IdUtils.fastSimpleUUID());
        data.setRetryTimes(1);
        data.setSource(response.getProtocolNum());
        data.setSendTime(DateUtils.getDateTimeNumber());
        data.setTopic(response.getTopic());
        return data;
    }
}

