/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.tcp.support;

import com.iplatform.tcp.util.ws.WebBroadCastResponse;
import com.iplatform.tcp.util.ws.WebDataResponse;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;
import com.walker.tcp.Response;
import com.walker.tcp.netty.WebSocketEngine;
import java.util.ArrayList;
import java.util.List;

public class WebSocketPush
extends AbstractPushObject<WebBroadCastResponse> {
    private WebSocketEngine webSocketEngine;

    public WebSocketPush() {
        this.setId(NotificationChannel.WebSocket.getIndex());
        this.setName(NotificationChannel.WebSocket.getName() + "\u63a8\u9001");
    }

    protected PushResult doPushContent(Notification notification, List<WebBroadCastResponse> data) throws PushException {
        PushResult pushResult = PushUtils.acquireSuccessPushResult();
        String error = null;
        for (WebBroadCastResponse response : data) {
            if (notification.getBroadcast()) {
                this.webSocketEngine.sendBroadcast((Response)response);
                this.logger.debug("websocket\u5e7f\u64ad\u76f4\u63a5\u53d1\u9001\uff0c\u6ca1\u6709\u72b6\u6001");
                return pushResult;
            }
            error = this.webSocketEngine.sendResponse((Response)response);
            if (!StringUtils.isNotEmpty((String)error)) continue;
            if (pushResult.getCode() == 0) {
                pushResult.setCode(-1);
            }
            pushResult.addOneFailed(response.getName());
        }
        return pushResult;
    }

    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.WebSocket;
    }

    public List<WebBroadCastResponse> translateToTarget(Notification notification) {
        ArrayList<WebBroadCastResponse> data = new ArrayList<WebBroadCastResponse>(2);
        WebBroadCastResponse webBroadCastResponse = null;
        if (notification.getBroadcast()) {
            this.logger.debug("websocket\u63a8\u9001\u5e7f\u64ad");
            webBroadCastResponse = new WebBroadCastResponse();
            webBroadCastResponse.setMessageId(notification.getId());
            webBroadCastResponse.setData(notification.getContent());
            data.add(webBroadCastResponse);
            return data;
        }
        int i = 1;
        for (String user : notification.getReceiverList()) {
            webBroadCastResponse = new WebDataResponse();
            webBroadCastResponse.setMessageId(notification.getId() + i);
            webBroadCastResponse.setData(notification.getContent());
            webBroadCastResponse.setName(user);
            data.add(webBroadCastResponse);
            ++i;
        }
        return data;
    }

    public void startup() {
    }

    public void setWebSocketEngine(WebSocketEngine webSocketEngine) {
        this.webSocketEngine = webSocketEngine;
    }
}

