package com.iplatform.base;

import com.iplatform.base.config.SecurityUserProperties;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.PasswordUtils;
import com.walker.web.UserPrincipal;
import com.walker.web.UserType;

import java.util.List;

/**
 * 获得当前登录用户认证信息。<p></p>
 * <pre>
 * 1.如果你的控制器必须在用户认证之后才能操作，就必须继承该对象，请参考: {@linkplain AbstractSecurityController}
 *
 * 2.如果你的控制器没有权限控制，则只需要集成<code>AbstractController</code>即可，
 * 请参考: {@linkplain AbstractController}
 * </pre>
 * @author 时克英
 * @date 2022-11-11
 */
public abstract class AbstractSecurityController extends AbstractController{

    /**
     * 验证密码是否符合平台政策。
     //     * @param encryptPassword 前端修改的密码（密文），RSA加密，后台要解密的
     * @param originPassword 原始明文密码
     * @return 返回错误提示，返回空表示成功
     * @date 2023-08-05
     */
    protected String validatePasswordRule(String originPassword){
//        String originPassword = PlatformRSAUtils.getRsaDecryptValue(encryptPassword, PlatformRSAUtils.PRIK);
        String error = PasswordUtils.filterText(originPassword);
        if(error != null){
            return error;
        }
        int passLevelConfig = this.acquireSecurityUserProperties().getPassLevel();
        if(!PasswordUtils.validateComplex(originPassword, passLevelConfig)){
            return "密码级别过低，请输入：大小写字母、数字以及至少一种特殊符号";
        }
        return null;
    }

    protected SecurityUserProperties acquireSecurityUserProperties(){
        return BeanContextAware.getBeanByType(SecurityUserProperties.class);
    }

    /**
     * 以流程角色登录获取权限，activiti7专用，后续会废弃。
     * @date 2023-03-21
     */
    @Deprecated
    protected void loginAsWorkflowRole(){
        this.acquireSecuritySpi().loginAsWorkflowRole();
    }

    /**
     * 判断当前登录用户是否超级管理员。
     * @return
     * @date 2022-11-27
     */
    protected boolean isSupervisor(){
        S_user_core user_core = this.getCurrentUser();
        if(user_core == null){
            throw new IllegalStateException("获取当前用户错误，未找到");
        }
        return user_core.getUser_type() == UserType.TYPE_SUPER;
    }

    /**
     * 返回当前用户具有的角色集合，注意:这里面会有权限使用的特定角色，如: <p> ROLE_SUPERVISOR, ROLE_USER, ROLE_ADMIN 等。</p>
     * <pre>
     *     其他的是系统角色管理的ID，因此数据库通过角色集合查询菜单并不影响结果。
     * </pre>
     * @return
     * @date 2022-11-27
     */
    public List<String> getCurrentUserRoleIdList(){
        return this.acquireSecuritySpi().getCurrentUserRoleIdList();
    }

    public UserPrincipal<S_user_core> getCurrentUserPrincipal(){
        return this.acquireSecuritySpi().getCurrentUserPrincipal();
    }

    /**
     * 返回用户指定菜单的权限标识(是否存在)，如果不存在返回空。
     * @param menuId 对应功能菜单ID
     * @return
     * @date 2022-12-21
     */
    protected String getCurrentDataScope(String menuId){
        UserPrincipal<S_user_core> userPrincipal = this.getCurrentUserPrincipal();
        return userPrincipal.getDataScope(menuId);
    }

    public S_user_core getCurrentUser(){
        return this.acquireSecuritySpi().getCurrentUser();
    }

    public long getCurrentUserId(){
        return this.acquireSecuritySpi().getCurrentUserId();
    }

    /**
     * 返回加密后的密文
     * @param password 明文密码
     * @return
     * @date 2022-12-13
     */
    public String encryptPassword(String password){
        return this.acquireSecuritySpi().encryptPassword(password);
    }

    /**
     * 比较提供的明文密码是否与加密的密码相同。
     * @param rawPassword 明文原始密码
     * @param encodedPassword 加密后的密码
     * @return
     */
    public boolean matchesPassword(String rawPassword, String encodedPassword){
        return this.acquireSecuritySpi().matchesPassword(rawPassword, encodedPassword);
    }

    private SecuritySpi acquireSecuritySpi(){
        return BeanContextAware.getBeanByType(SecuritySpi.class);
    }
}
