package com.iplatform.base;

/**
 * 可变参数常量定义，变量的KEY常量对应数据库中的: config_key 字段。
 * @author 时克英
 * @date 2022-11-30
 */
public class ArgumentsConstants {

    public static final String KEY_SECURITY_CAPTCHA_ENABLED = "security.captcha.enabled";

    /**
     * 用户初始密码参数，明文密码。
     * @date 2022-12-13
     */
    public static final String KEY_SECURITY_PASSWORD_INIT = "security.password.init";

    /**
     * 安全：是否开启用户注册
     * @date 2023-07-28
     */
    public static final String KEY_SECURITY_ACCOUNT_REGISTER = "security.account.register";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 平台配置参数，以Tab分组方式展示的界面。2023-05-12
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** 移动端域名 */
    public static final String CONFIG_KEY_SITE_URL = "site_url";

    /** 图片上传类型 1本地 2七牛云 3OSS 4COS, 默认本地
     * <p>支持系统自己的定义常量，参考：{@linkplain com.walker.file.FileStoreType}</p>
     * */
    public static final String CONFIG_UPLOAD_TYPE = "uploadType";

    /** 全局本地图片域名 */
    public static final String CONFIG_LOCAL_UPLOAD_URL = "localUploadUrl";
    /** 七牛云上传URL */
    public static final String CONFIG_QN_UPLOAD_URL = "qnUploadUrl";
    /** 阿里云上传URL */
    public static final String CONFIG_AL_UPLOAD_URL = "alUploadUrl";
    /** 腾讯云上传URL */
    public static final String CONFIG_TX_UPLOAD_URL = "txUploadUrl";
    /** FTP上传URL */
    public static final String CONFIG_FTP_UPLOAD_URL = "ftpUploadUrl";

    /** 版权-公司信息 */
    public static final String CONFIG_COPYRIGHT_COMPANY_INFO = "copyright_company_name";
    /** 版权-公司图片 */
    public static final String CONFIG_COPYRIGHT_COMPANY_IMAGE = "copyright_company_image";

    /** 图片上传,拓展名 */
    public static final String UPLOAD_IMAGE_EXT_STR_CONFIG_KEY = "image_ext_str";
    /** 图片上传,最大尺寸 */
    public static final String UPLOAD_IMAGE_MAX_SIZE_CONFIG_KEY = "image_max_size";
    /** 文件上传,拓展名 */
    public static final String UPLOAD_FILE_EXT_STR_CONFIG_KEY = "file_ext_str";
    /** 文件上传,最大尺寸 */
    public static final String UPLOAD_FILE_MAX_SIZE_CONFIG_KEY = "file_max_size";

    /** 移动端顶部logo */
    public static final String CONFIG_KEY_MOBILE_TOP_LOGO = "mobile_top_logo";
    /** 移动端登录 logo */
    public static final String CONFIG_KEY_MOBILE_LOGIN_LOGO = "mobile_login_logo";
    /** 商品分类页配置 */
    public static final String CONFIG_CATEGORY_CONFIG = "category_page_config";
    /** 是否隐藏一级分类 */
    public static final String CONFIG_IS_SHOW_CATEGORY = "is_show_category";
    /** 首页商品列表模板配置 */
    public static final String CONFIG_IS_PRODUCT_LIST_STYLE = "homePageSaleListStyle";

    /** 底部导航—是否自定义 */
    public static final String CONFIG_BOTTOM_NAVIGATION_IS_CUSTOM = "bottom_navigation_is_custom";

    /** 客服类型 */
    public static final String CONFIG_CONSUMER_TYPE = "consumer_type";
    /** 客户类型-H5 */
    public static final String CONSUMER_TYPE_H5 = "h5";
    /** 客户类型-热线 */
    public static final String CONSUMER_TYPE_HOTLINE = "hotline";
    /** 客服H5链接 */
    public static final String CONFIG_CONSUMER_H5_URL = "consumer_h5_url";
    /** 客服电话 */
    public static final String CONFIG_CONSUMER_HOTLINE = "consumer_hotline";
    /** 店铺街开关 */
    public static final String CONFIG_KEY_SHOP_STREET_SWITCH = "shop_street_switch";
    /** 客服电话 */
    public static final String CONFIG_CONSUMER_MESSAGE = "consumer_message";
    /** 客服邮箱 */
    public static final String CONFIG_CONSUMER_EMAIL = "consumer_email";

    /** 自定义表单开关：关闭 */
    public static final String CONFIG_FORM_SWITCH_CLOSE = "'0'";
    /** 自定义表单开关：开启 */
    public static final String CONFIG_FORM_SWITCH_OPEN = "'1'";

    /** 公共开关：0关闭 */
    public static final String COMMON_SWITCH_CLOSE = "0";
    /** 公共开关：1开启 */
    public static final String COMMON_SWITCH_OPEN = "1";
}
