package com.iplatform.base;

import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;

import java.util.List;

/**
 * 分类缓存对象。
 * @author 时克英
 * @date 2023-05-17
 */
public interface CategoryCacheProvider {

    List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList, int owner);

    /**
     * 返回分类树结构（目前只有两级）
     * @param type 归属类别：1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类， 6 配置分类， 7 秒杀配置
     * @param status 状态：0正常，1失效
     * @param name 名称（目前未知）
     * @param owner 归属（平台或商户）
     * @return
     */
    List<CategoryTreeVo> getListTree(Integer type, Integer status, String name, int owner);

    S_category get(int id);

    void save(S_category category);

    void update(S_category category);

    void remove(int id);
}
