package com.iplatform.base;

import org.bouncycastle.pqc.crypto.newhope.NHOtherInfoGenerator;

public class Constants {

    /**
     * 超级管理员默认的登录名称。
     * @author 时克英
     * @date 2022-10-31
     */
    public static final String SUPERVISOR_NAME_DEFAULT = "supervisor";

    /**
     * 超级管理员ID = 0
     */
    public static final long SUPERVISOR_ID = 0L;

    /**
     * 超级管理员姓名
     */
    public static final String SUPERVISOR_NAME_ZH = "超级管理用户";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 用户缓存token前缀。
     * @date 2022-11-01
     */
    public static final String USER_ONLINE_PREFIX = "login_token:";

    /**
     * 验证码 redis key
     * @date 2022-11-07
     */
    public static final String CAPTCHA_CODE_PREFIX = "captcha_codes:";

    /**
     * 当组织机构表没有记录时，默认显示机构名称。
     * @date 2022-12-01
     */
    public static final String DEFAULT_ORG_NAME = "默认单位";

    /**
     * 数据权限前缀。
     * @date 2022-12-21
     */
    public static final String DATA_SCOPE_NAME = "data_scope,";

    /**
     * 前端过来的提交参数，如果必须提供则需要检查，返回非法提示。
     * @date 2023-06-01
     */
    public static final String ERROR_ARGUMENT = "参数错误";

    /**
     * 平台附件上传，映射的浏览路径。
     * @date 2023-06-09
     */
    public static final String FILE_CONTEXT_PATH_MAPPING = "/file/**";
    /**
     * 平台附件上传，本地文件包含的路径，用于从路径中判断是否URL地址。
     * @date 2023-06-10
     */
    public static final String FILE_CONTEXT_PATH = "/file/";

    /**
     * 设置错误日志，内容最大长度，默认：255
     * @date 2023-08-13
     */
    public static final int LOG_ERROR_MAX_SIZE = 255;

    /** 数据状态：正常 */
    public static final int STATUS_NORMAL = 0;
    /** 数据状态：禁用 */
    public static final int STATUS_DISABLE = 1;


    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 缓存名称常量，2023-01-04
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public static final String CACHE_NAME_MENU = "cache.base.menu";
    public static final String CACHE_NAME_CAPTCHA = "cache.base.captcha";
    public static final String CACHE_NAME_DEPT = "cache.base.dept";
    public static final String CACHE_NAME_HOST = "cache.system.host";
    public static final String CACHE_NAME_USER = "cache.base.user";
    public static final String CACHE_NAME_ONLINE_USER = "cache.base.user_online";
    public static final String CACHE_NAME_ARGUMENTS = "cache.base.arguments";
    public static final String CACHE_NAME_DICT = "cache.base.dict";
    public static final String CACHE_NAME_PUSH = "cache.base.push";
    public static final String CACHE_NAME_CATEGORY = "cache.base.category";
    public static final String CACHE_NAME_FORM = "cache.base.form";
    public static final String CACHE_NAME_GROUP = "cache.base.group";
    public static final String CACHE_NAME_USER_LOGIN = "cache.base.user_login";
    public static final String CACHE_NAME_WECHAT = "cache.base.wechat";
    public static final String CACHE_NAME_NOTIFICATION_TEMPLATE = "cache.notify.template";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~ TCP 模块核心常量，2023-04-17
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    public static final String QUEUE_TYPE_MEMORY = "memory";

    /**
     * 推送范围定义常量：data 普通单个，broadcast 广播。
     * @date 2023-04-21
     */
    public static final String PUSH_SCOPE_DATA = "data";
    public static final String PUSH_SCOPE_BROAD_CAST = "broadcast";

    /**
     * 模拟短信推送者ID
     * @date 2023-04-25
     */
    public static final String PUSH_SMS_ID_MOCK = "mock_sms_push";

    /**
     * 推送平台提醒时，from字段默认值
     * @date 2023-04-25
     */
    public static final String PUSH_FROM_DEFAULT = "platform";
    public static final String PUSH_OPTION_TYPE_DEFAULT = "no_type";

    /**
     * 消息通知，存放临时缓存前缀
     * @date 2023-04-27
     */
    public static final String PUSH_CACHE_PREFIX = "notification:";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~ 导入导出相关，2023-05-08
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 生成导入模板文件前缀。
     * @date 2023-05-08
     */
    public static final String TEMPLATE_IMPORT_PREFIX = "template_";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~ 电商基础，2023-05-15
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 数据归属：平台，> 0 表示商户ID
     */
    public static final int OWNER_PLATFORM = -1;

    /**
     * 系统基础分类的type类型。<p></p>
     * 类型，1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类， 6 配置分类， 7 秒杀配置
     * @date 2023-05-18
     */
    public static final int CATEGORY_TYPE_CONFIG = 6;
    public static final int CATEGORY_TYPE_ATTACH = 2;

    /** 文件导出下载拦截关键字 */
    public static final String DOWNLOAD_FILE_KEYWORD = "downloadf";

    /** 文件前端上传后下载关键字 */
    public static final String UPLOAD_AFTER_FILE_KEYWORD = "uploadf";
    public static final String UPLOAD_AFTER_IMAGE_KEYWORD = "uploadi";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~ 系统分组配置项，2023-06-23
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** 首页banner滚动图 */
    public static final Integer GROUP_DATA_ID_INDEX_BANNER = 1;
    /** 首页金刚区 */
    public static final Integer GROUP_DATA_ID_INDEX_MENU = 2;
    /** 热门搜索 */
    public static final Integer GROUP_DATA_ID_INDEX_KEYWORDS = 3;
    /** 移动端_充值套餐设置 */
    public static final Integer GROUP_DATA_ID_RECHARGE_PACKAGE = 4;
    /** 个人中心菜单 */
    public static final Integer GROUP_DATA_ID_USER_CENTER_MENU = 5;
    /** 个人中心轮播图 */
    public static final Integer GROUP_DATA_ID_USER_CENTER_BANNER = 7;
    /** 分销推广海报Banner */
    public static final Integer GROUP_DATA_ID_SPREAD_BANNER_LIST = 10;
    /** 移动端_订单状态_图 */
    public static final Integer GROUP_DATA_ID_ORDER_STATUS_IMAGE = 13;
    /** 移动端_底部导航 */
    public static final Integer GROUP_DATA_ID_BOTTOM_NAVIGATION = 14;

    /**
     * 分组配置数据中，图片关键词名字。
     * @date 2023-06-24
     */
    public static final String GROUP_DATA_IMAGE = "pic";

    /** 公共开关：0关闭 */
    public static final String COMMON_SWITCH_CLOSE = "0";
    /** 公共开关：1开启 */
    public static final String COMMON_SWITCH_OPEN = "1";

    /** 自定义表单开关：关闭 */
    public static final String CONFIG_FORM_SWITCH_CLOSE = "'0'";
    /** 自定义表单开关：开启 */
    public static final String CONFIG_FORM_SWITCH_OPEN = "'1'";
}
