package com.iplatform.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.iplatform.model.po.S_user_core;
import com.walker.web.DataStatus;
import com.walker.web.LoginType;
import com.walker.web.UserType;
import com.walker.web.principal.AbstractUserPrincipal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 平台默认的用户凭证对象，主要用于登录认证、权限拦截判断使用。
 * 业务模块不会使用该对象。
 * @author 时克英
 * @date 2022-10-31
 */
public class DefaultUserPrincipal extends AbstractUserPrincipal<S_user_core> {

    private long lastLoginTime = 0;
    private LoginType lastLoginType = LoginType.UserPassword;

    private List<String> roleIdList = new ArrayList<>(4);

    // 2022-12-21 用户菜单对应的数据权限
    // key = menuId, value = dept_org(如：本单位)
    private Map<String, String> dataScopeMap = new HashMap<>();

    public DefaultUserPrincipal(){}

    public DefaultUserPrincipal(S_user_core user_core){
        if(user_core == null){
            throw new IllegalArgumentException("user info is required!");
        }
        this.setUserInfo(user_core);
        this.setId(String.valueOf(user_core.getId()));
        this.setUserName(user_core.getUser_name());
        this.setPassword(user_core.getPassword());
    }

    @JsonIgnore
    @Override
    public boolean isEnabled() {
        return this.getUserInfo().getStatus() == DataStatus.CONST_NORMAL;
    }

    @JsonIgnore
    @Override
    public boolean isTokenExpired(String token) {
        // 这里暂未实现，集成后腰修改
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isAccountLocked() {
        // 这里暂未实现，集成后腰修改
        return false;
    }

    @JsonIgnore
    @Override
    public boolean validateMd5Password(String encryption) {
        return false;
    }

    @Override
    public long getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Override
    public LoginType getLastLoginType() {
        return this.lastLoginType;
    }

    public void setLastLoginTime(long loginTime){
        this.lastLoginTime = loginTime;
    }

    public void setLastLoginType(LoginType loginType){
        this.lastLoginType = loginType;
    }

    /**
     * 返回该用户拥有的角色ID集合。
     * @return
     */
    public List<String> getRoleIdList() {
        return roleIdList;
    }

    public void setRoleIdList(List<String> roleIdList) {
        this.roleIdList = roleIdList;
    }

    @JsonIgnore
    @Override
    public boolean isSupervisor() {
        return this.getUserInfo().getUser_type().intValue() == UserType.TYPE_SUPER;
    }

    /**
     * 添加一条数据权限
     * @param menuId 菜单ID，对应一个功能
     * @param dataScopeValue 数据权限标识
     * @date 2022-12-21
     */
    @JsonIgnore
    public void addDataScope(String menuId, String dataScopeValue){
        this.dataScopeMap.put(menuId, dataScopeValue);
    }
    public void setDataScopeMap(Map<String, String> dataScopeMap){
        this.dataScopeMap = dataScopeMap;
    }

    /**
     * 根据菜单ID，查询是否具有特定的数据权限。
     * @param menuId
     * @return
     * @date 2022-12-21
     */
    @JsonIgnore
    @Override
    public String getDataScope(String menuId){
        return this.dataScopeMap.get(menuId);
    }

    public Map<String, String> getDataScopeMap(){
        return this.dataScopeMap;
    }

    /**
     * 该方法测试redis序列化使用，暂时不用。
     * @param user_core
     * @date 2022-11-15
     */
    @Deprecated
    public void setup(S_user_core user_core){
        this.setUserInfo(user_core);
        this.setId(String.valueOf(user_core.getId()));
        this.setUserName(user_core.getUser_name());
        this.setPassword(user_core.getPassword());
    }
}
