package com.iplatform.base;

import com.iplatform.model.po.S_dept;

import java.util.List;

/**
 * 组织机构缓存提供者使用规范。<p></p>
 * 因为存在多种实现，如: Redis 或者 内存，因此需要抽象该接口。
 * @author 时克英
 * @date 2022-12-03
 */
public interface DeptCacheProvider {

    /**
     * 设置是否允许缓存机构的子机构关系，<br>
     * 在机构数量非常庞大的时候，即便 Redis 也不太适合存储该关系，因为通常界面会展示较多数据，<br>
     * 此时可能退化成数据库查询，或者通过其他 NoSQL 数据库实现。
     * @param allow
     * @date 2022-12-03
     */
    void setAllowCacheChildren(boolean allow);

    S_dept getDept(long deptId);

    void updateDept(S_dept s_dept);

    void removeDept(long deptId);

    void putDept(S_dept s_dept);

    /**
     * 返回给定机构，下一级子机构ID集合。
     * @param deptId 给定当前机构ID
     * @return
     * @date 2022-12-03
     */
    List<String> getChildrenDeptIdOneLevel(long deptId);

    /**
     * 返回给定机构，下一级子机构对象集合。
     * @param deptId 给定当前机构ID
     * @return
     * @date 2022-12-03
     */
    List<S_dept> getChildrenDeptOneLevel(long deptId);
}
